<?php

/**
 * Single variation cart button
 *
 * @see https://woo.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 7.0.1
 */

defined('ABSPATH') || exit;

global $product;
$base_url = get_home_url(null, '', 'https');


$addons_group2 = null;

$category = get_term_by('slug', 'ADDONS', 'product_cat');
if ($category) {
    $args = array(
        'post_type' => 'product',
        'posts_per_page' => -1,
        'tax_query' => array(
            array(
                'taxonomy' => 'product_cat',
                'field' => 'term_id',
                'terms' => $category->term_id,
            ),
        ),
    );
    $products_query = new WP_Query($args);
}


$product_in_cart_slugs = array();
if (!WC()->cart->is_empty()) {

    foreach (WC()->cart->get_cart() as $cart_item_key => $cart_item) {
        $product_in_cart = $cart_item['data'];
        $product_in_cart_slugs[] = $product_in_cart->get_slug();
    }
}
$product_in_cart_slugs_json = json_encode($product_in_cart_slugs);
?>


<div class="woocommerce-variation-add-to-cart variations_button">


    <!-- PRODUCT ID ADD -->
    <div class="addons hidden">
        <span style="color: #777;font-weight: 700;"> Addons:</span>

        <script>
            const base_url = "<?= $base_url ?>";
            const product_in_cart_slugs_json = <?= $product_in_cart_slugs_json ?>;
            jQuery(document).ready(function ($) {

                 jQuery('body').on('click', '.single_add_to_cart_button', function(e) {
                    jQuery("#boots-variation_size").css('border', '1px solid rgba(0, 0, 0, .09)');
                    if (jQuery("#wetsuit-check").is(":checked") && jQuery("#wetsuit-variation_size").val().trim()=="" ) {
                        jQuery("#wetsuit-variation_size").css('border', '1px solid red');
                        e.preventDefault();
                     return;
                    } else  jQuery("#wetsuit-variation_size").css('border', '1px solid rgba(0, 0, 0, .09)');

                    if (jQuery("#boots-check").is(":checked") && jQuery("#boots-variation_size").val().trim()=="" ) {
                        jQuery("#boots-variation_size").css('border', '1px solid red');
                        e.preventDefault();
                     return;
                    } else  jQuery("#boots-variation_size").css('border', '1px solid rgba(0, 0, 0, .09)');



    });

                if (jQuery('select#pa_how-many-days').val()) {

                    jQuery('select#pa_how-many-days').val(null)

                }
                jQuery('select#pa_how-many-days').on('change', function () {


                    var option = jQuery(this).find(":selected").val();
                    var text = jQuery(this).find(":selected").text();
                    var posicao = jQuery(this)[0].selectedIndex;
                    var authCode = btoa(
                        'ck_947981e7fe4c1e9c2ebb4e96b540db54d1852fa9:cs_fcd22dba2b46820e5bd8c33d4a00050bf225567c'
                    );

                    //WETSUIT or //BOOTS
                    $('.addons_variation').each(function () {

                        const slug = $(this).data('slug');
                        jQuery(".single_add_to_cart_button.button").prop('disabled', true);
                        jQuery(".single_add_to_cart_button.button").addClass('loading');
                        jQuery.ajax({
                            url: base_url + '/wp-json/wc/v3/products?slug=' + slug,
                            method: 'GET',
                            headers: {
                                'Authorization': "Basic " + authCode
                            },
                            success: function (data) {
                                get_variation(data[0].variations[posicao - 1],
                                    slug, posicao);
                                jQuery(".single_add_to_cart_button.button").prop(
                                    'disabled', false);
                                jQuery('.addons').removeClass('hidden');
                                jQuery(".single_add_to_cart_button.button").removeClass(
                                    'loading');
                            }
                        });
                    });

                    function get_variation(id, classdiv, dias) {

                        jQuery.ajax({
                            url: base_url + '/wp-json/wc/v3/products/' + id,
                            method: 'GET',
                            headers: {
                                'Authorization': "Basic " + authCode
                            },
                            success: function (data) {

                                jQuery('li.' + classdiv + ' input[type="hidden"]').val(data.id);
                                jQuery('li.' + classdiv + ' .days-price .price_day').text("+" +
                                    data
                                        .price + '€');
                                jQuery('li.' + classdiv + '').attr('data-price', data.price);

                                jQuery('li.' + classdiv + " .days-price .dias").text(dias +
                                    ' days | ');


                            }
                        });


                    }

                    function updatePrice() {

                        let price_addons = 0;
                        $('.addons_variation').find('input[type="checkbox"]').each(function () {
                            if (!$(this).is(":checked")) return;
                            price_addons += parseFloat($(this).closest('li').attr('data-price'));

                        });

                        $('input[name="addons_simple[]"]').each(function () {

                            if ($(this).is(":checked")) {
                                price_addons += parseFloat($(this).attr('data-price'));


                            }
                        });

                        var producto = jQuery('.woocommerce-variation-price .woocommerce-Price-amount bdi')
                            .text();
                        producto = parseFloat(producto.replace('€', ''));
                        var new_total = producto + price_addons;

                        jQuery('span.preco-total').text(new_total);
                    }
                    jQuery('div.addons').on('DOMSubtreeModified', function () {

                        updatePrice();

                    });
                    jQuery('input[type=checkbox]').change(function () {

                        updatePrice();

                    });
                });

                $('#pack-explorer_simple').change(function () {
                    if (!$(this).is(":checked")) return;

                    if (product_in_cart_slugs_json.includes(
                        "pack-explorer")) {
                        showAlertPopUp({
                            btn_primary_text: "OK",
                            msg: "<?= str_replace("\n", "", preg_replace("/\r|\n/", "", get_option('pack-explorer_already_added'))) ?>",
                        });
                        $(this).prop('checked', false);
                        return;
                    }

                    if ((product_in_cart_slugs_json.includes(
                        "roof-rack") && product_in_cart_slugs_json.includes(
                            "locker"))) {
                        showAlertPopUp({
                            btn_primary_text: "OK",
                            msg: "<?= str_replace("\n", "", preg_replace("/\r|\n/", "", get_option('locker_roof_already_added'))) ?>",
                        });
                        $(this).prop('checked', false);
                        return;
                    }

                    if ($("#roof-rack_simple").is(":checked") && $("#locker_simple").is(":checked")) {
                        showAlertPopUp({
                            btn_primary_text: "OK",
                            msg: "<?= str_replace("\n", "", preg_replace("/\r|\n/", "", get_option('locker_roof_already_selected'))) ?>",
                        });
                        $(this).prop('checked', false);
                        return;
                    }

                    if (product_in_cart_slugs_json
                        .includes(
                            "roof-rack")) {
                        showAlertPopUp({
                            btn_primary_text: "OK",
                            msg: "<?= str_replace("\n", "", preg_replace("/\r|\n/", "", get_option('roof-rack_already_added'))) ?>",
                        });
                        $(this).prop('checked', false);
                        return;
                    }
                    if (product_in_cart_slugs_json.includes(
                        "locker")) {
                        showAlertPopUp({
                            btn_primary_text: "OK",
                            msg: "<?= str_replace("\n", "", preg_replace("/\r|\n/", "", get_option('locker_already_added'))) ?>",
                        });
                        $(this).prop('checked', false);
                        return;
                    }
                    if ($("#roof-rack_simple").is(":checked")) {
                        showAlertPopUp({
                            btn_primary_text: "OK",
                            msg: "<?= str_replace("\n", "", preg_replace("/\r|\n/", "", get_option('roof-rack_already_selected'))) ?>",
                        });
                        $(this).prop('checked', false);
                    } else if ($("#locker_simple").is(":checked")) {
                        showAlertPopUp({
                            btn_primary_text: "OK",
                            msg: "<?= str_replace("\n", "", preg_replace("/\r|\n/", "", get_option('locker_already_selected'))) ?>",
                        });
                        $(this).prop('checked', false);
                    }



                });

                $("#roof-rack_simple, #locker_simple").change(function () {
                    if (!$(this).is(":checked")) return;

                    if (product_in_cart_slugs_json.includes(
                        "pack-explorer")) {
                        showAlertPopUp({
                            btn_primary_text: "OK",
                            msg: "<?= str_replace("\n", "", preg_replace("/\r|\n/", "", get_option('pack-explorer_already_added'))) ?>",
                        });
                        $(this).prop('checked', false);
                        return;
                    }

                    if ($('#pack-explorer_simple').is(":checked")) {
                        showAlertPopUp({
                            btn_primary_text: "OK",
                            msg: "<?= str_replace("\n", "", preg_replace("/\r|\n/", "", get_option('pack-explorer_already_selected'))) ?>",
                        });
                        $(this).prop('checked', false);
                        return;
                    }

                    if ($(this).attr('id') == 'roof-rack_simple' && product_in_cart_slugs_json
                        .includes(
                            "roof-rack")) {
                        showAlertPopUp({
                            btn_primary_text: "OK",
                            msg: "<?= str_replace("\n", "", preg_replace("/\r|\n/", "", get_option('roof-rack_already_added'))) ?>",
                        });
                        $(this).prop('checked', false);
                        return;
                    }
                    if ($(this).attr("id") == 'locker_simple' && product_in_cart_slugs_json.includes(
                        "locker")) {
                        showAlertPopUp({
                            btn_primary_text: "OK",
                            msg: "<?= str_replace("\n", "", preg_replace("/\r|\n/", "", get_option('locker_already_added'))) ?>",
                        });
                        $(this).prop('checked', false);
                        return;
                    }
                });


            });
            jQuery(document).ready(function ($) {
                // Aguardar o evento "added_to_cart"
                $('body').on('added_to_cart', function (event, fragments, cart_hash, $button) {
                    // Interromper o redirecionamento padrão
                    event.preventDefault();

                    // Aqui você pode executar as ações desejadas após o produto ser adicionado ao carrinho
                    console.log('Produto adicionado ao carrinho!');

                    // Por exemplo, você pode exibir uma mensagem de sucesso
                    alert('Produto adicionado ao carrinho!');
                });
            });
        </script>

        <ul class="addons_variation_list" style="list-style: none; margin:0; padding: 0;">
            <?php
            if (isset ($products_query) && $products_query->have_posts()) {
                // Loop pelos produtos
                while ($products_query->have_posts()) {
                    $products_query->the_post();
                    $product_id = get_the_ID();

                    $product_slug = get_post_field('post_name', $product_id);

                    /*
                'id'=>get_the_ID(),
                'title'=>get_the_title(),
                'product_slug'=>$product_slug,
                */
                    if ($product_slug == 'wetsuit' || $product_slug == 'boots') {
                        ?>
                        <li class="<?= $product_slug ?> addons_variation" data-slug="<?= $product_slug ?>" data-price=""
                            style="list-style: none; margin:18px 0; padding: 0;display:flex;align-items: center; flex-wrap: wrap;gap: 16px;">
                            <div>
                                <input type="hidden" name="<?= $product_id ?>-variation" value="">
                                <input type="checkbox" id="<?= $product_slug ?>-check" name="addons_variation[]"
                                    value="<?= $product_id ?>" style="margin:0 8px;padding:0;">
                                <label for="<?= $product_slug ?>-check" style="margin:0;color:#555">
                                    <?= get_the_title() ?>
                                </label>
                            </div>
                            <div class="days-price" style="margin:0 6px;">
                                <span class="dias"></span>
                                <span style="color:var(--fs-color-primary);" class="price_day"></span>
                            </div>

                            <input placeholder="Your Size" type="text" id="<?= $product_slug ?>-variation_size"  name="<?= $product_id ?>-variation_size" value=""
                                style="margin:0;width:150px;font-size: 14px;">
                            <?php
                            if ($product_slug == 'wetsuit') {



                                $image_id = get_option('imaege_addons_brand_onrill');
                                $image_url = wp_get_attachment_url($image_id);
                                ?>
                                <img src="<?= esc_url($image_url) ?>" style="max-width: 110px; height: auto;" />
  <?php
                            } ?>

                        </li>
                        <?php
                    } else {
                        if ($product_slug == 'pack-explorer')
                            $extraText = 'Locker + Roof Rack -';
                        else
                            $extraText = '';
                        $product_addons = wc_get_product($product_id);
                        $product_price = $product_addons->get_price();
                        $addons_group2 .= '<li style="margin:0px"><div style="font-weight: 700;color: #555"> <input data-price="' . $product_price . '" type="checkbox" id="' . $product_slug . '_simple" name="addons_simple[]" value="' . $product_id . '" style="margin:0 10px;padding:0;"><label  style="color: #555" for="' . $product_slug . '_simple">' . get_the_title() . '</label> </div>  <div style="width: 100%;text-align: center;font-size: 12px;">(' . $extraText . $product_price . '€)</div></li>';
                    }
                }
                wp_reset_postdata(); // Restaura os dados do post original
            }
            ?>

            <li class="addons_simple"
                style="list-style: none; margin:18px 0;  margin-bottom: 28px; padding: 0;display:flex;   align-items: center;">
                <ul
                    style="list-style: none; margin: 0px; padding: 0;display:flex;align-items: center;justify-content: space-between; flex-wrap: wrap;gap: 20px;">
                    <?= $addons_group2 ?>
                </ul>
            </li>


        </ul>

    </div>
    <!-- -->

    <?php do_action('woocommerce_before_add_to_cart_button'); ?>
    <?php
    do_action('woocommerce_before_add_to_cart_quantity');

    /*
 woocommerce_quantity_input(
        array(
            'min_value'   => apply_filters('woocommerce_quantity_input_min', $product->get_min_purchase_quantity(), $product),
            'max_value'   => apply_filters('woocommerce_quantity_input_max', $product->get_max_purchase_quantity(), $product),
            'input_value' => isset($_POST['quantity']) ? wc_stock_amount(wp_unslash($_POST['quantity'])) : $product->get_min_purchase_quantity(), // WPCS: CSRF ok, input var ok.
        )
    );
    */

    do_action('woocommerce_after_add_to_cart_quantity');
    ?>

    <button type="submit"
        class="single_add_to_cart_button button alt<?php echo esc_attr(wc_wp_theme_get_element_class_name('button') ? ' ' . wc_wp_theme_get_element_class_name('button') : ''); ?>">
        <?#php echo esc_html($product->single_add_to_cart_text()); ?>
        ADD TO CART
    </button>
    <h4>Preço Total: <span class="preco-total"></span>€</h4>
    <?php do_action('woocommerce_after_add_to_cart_button'); ?>

    <input type="hidden" name="add-to-cart" value="<?php echo absint($product->get_id()); ?>" />
    <input type="hidden" name="product_id" value="<?php echo absint($product->get_id()); ?>" />
    <input type="hidden" name="variation_id" class="variation_id" value="0" />
</div>
