<?php

defined( 'ABSPATH' ) || exit;

if ( ! class_exists( 'Pwf_Parse_Query_Vars' ) ) {

	class Pwf_Parse_Query_Vars {
		protected $filter_id;
		protected $filter_setting;
		protected $filter_items;
		protected $tax_query         = array();
		protected $meta_query        = array();
		protected $has_price_item    = false;
		protected $price_item_values = '';
		protected $selected_items    = array(); // hold url key as key and selected values for item selected
		protected $orderby           = '';
		protected $authors_id        = array();
		protected $date_query        = array();
		protected $custom_tax_query  = array();
		protected $custom_meta_query = array();
		protected $tax_query_items   = array();
		protected $filter_items_key  = array(); // this include date and price hold active filter items keys used in api
		protected $search_query      = '';
		protected $query_string      = array();
		protected $outofstock_ids    = array();
		protected $outofstock_terms  = array();
		protected $has_on_sale       = false;
		protected $stock_status      = 'none'; // May be none, active, instock, outofstock
		protected $search_inside     = 'all';
		protected $post_type         = 'product';

		/**
		 * @since 1.0.0, 1.2.9, 1.5.5
		 */
		public function __construct( $filter_id, $selected_options_by_user ) {
			$this->filter_id = $filter_id;

			$meta = Pwf_Filter_Manager::get_filter_settings_and_items( $this->filter_id );

			if ( empty( $meta ) ) {
				return;
			}

			$this->filter_items   = $meta['items'];
			$this->filter_setting = $meta['setting'];
			$this->post_type      = $this->filter_setting['post_type'] ?? $this->post_type;

			add_action( 'pwf_init_parse_query', array( $this, 'integrate_woo_shortcode' ), 10, 1 );

			do_action( 'pwf_init_parse_query', $this->filter_id, $meta );

			$this->parse_query_vars( $selected_options_by_user );
			$this->set_out_of_stock_product_variations_ids();
		}

		public function get_filter_items_key() {
			return $this->filter_items_key;
		}
		public function get_filter_id() {
			return $this->filter_id;
		}

		public function get_tax_query() {
			return $this->tax_query;
		}

		public function get_meta_query() {
			return $this->meta_query;
		}

		public function get_date_query() {
			return $this->date_query;
		}

		public function get_filter_items() {
			return $this->filter_items;
		}

		public function get_filter_setting() {
			return $this->filter_setting;
		}

		public function selected_items() {
			return $this->selected_items;
		}

		public function has_price_item() {
			return $this->has_price_item;
		}

		public function get_current_min_max_price() {
			return $this->price_item_values;
		}

		public function get_products_orderby() {
			return $this->orderby;
		}

		public function get_authors_id() {
			return $this->authors_id;
		}

		/**
		 * Use to get tax_query for selected options by user on frontend
		 * Without add taxonomy archive page
		 */
		public function get_tax_query_filter_items() {
			return $this->tax_query_items;
		}

		/**
		 * @since 1.4.7
		 */
		public function has_on_sale() {
			return $this->has_on_sale;
		}

		public function get_search_inside() {
			return $this->search_inside;
		}
		/**
		 * Used to get tax query with product visibilty
		 * and add current archive product page like category, tag, taxonomy
		 */
		public function get_custom_tax_query() {
			return $this->custom_tax_query;
		}

		public function get_custom_meta_query() {
			return $this->custom_meta_query;
		}

		public function get_search_query() {
			return $this->search_query;
		}

		public function get_query_string() {
			return implode( '&', $this->query_string );
		}

		public function get_out_of_stock_ptoduct_variations_ids() {
			if ( ! empty( $this->outofstock_ids ) ) {
				$this->outofstock_ids = array_unique( $this->outofstock_ids, SORT_NUMERIC );
			}
			return $this->outofstock_ids;
		}

		public function get_current_stock_status() {
			return $this->stock_status;
		}

		/**
		 * Check stock status
		 */
		public function is_stock_status_active() {
			$is_active    = false;
			$stock_status = $this->get_current_stock_status();
			$product_ids  = $this->get_out_of_stock_ptoduct_variations_ids();
			if ( in_array( $stock_status, array( 'instock', 'outofstock' ), true ) && ! empty( $product_ids ) ) {
				$is_active = true;
			}

			return $is_active;
		}

		/**
		 * check if the current page is_tax()
		 * True is mean add current_taxonomy to to filter items ( parse_query )
		 * Usefule if the front-end user brwosing the categoty page so we counted terms for that page
		 *
		 * @since 1.0.0, 1.6.6
		 *
		 * @return array tax_query | Empty array
		 */
		private function get_current_page_tax_query() {
			$tax_query = array();
			if ( ! empty( $GLOBALS['pwf_main_query']['taxonomy_name'] ) && ! empty( $GLOBALS['pwf_main_query']['taxonomy_id'] ) ) {
				$tax_query[] = array(
					'taxonomy'         => sanitize_key( $GLOBALS['pwf_main_query']['taxonomy_name'] ),
					'field'            => 'term_id',
					'terms'            => absint( $GLOBALS['pwf_main_query']['taxonomy_id'] ),
					'operator'         => 'IN',
					'include_children' => true,
				);
			}

			return $tax_query;
		}

		private function append_custom_tax_query( $filter_tax_query ) {
			$product_visibility = array();
			if ( 'product' === $this->post_type ) {
				$product_visibility = Pwf_Woo_Utilities::get_product_visibility();
			}

			$current_shop_archive = $this->get_current_page_tax_query();

			$this->custom_tax_query = apply_filters( 'pwf_parse_taxonomy_query', array_merge( $product_visibility, $current_shop_archive ), $this->filter_id );

			$tax_query = array_merge( $this->custom_tax_query, $filter_tax_query );

			if ( ! isset( $tax_query['relation'] ) ) {
				$tax_query['relation'] = 'AND';
			}

			return $tax_query;
		}

		private function append_custom_meta_query( $filter_meta_query ) {
			$meta_query = array();
			$meta_query = apply_filters( 'pwf_parse_meta_query', $meta_query, $this->filter_id );
			if ( ! empty( $meta_query ) ) {
				$meta_query['relation'] = 'AND';
			}
			$this->custom_meta_query = $meta_query;
			$filter_meta_query       = array_merge( $this->custom_meta_query, $filter_meta_query );
			if ( ! empty( $filter_meta_query ) ) {
				if ( ! isset( $filter_meta_query['relation'] ) ) {
					$filter_meta_query['relation'] = 'AND';
				}
			}

			return $filter_meta_query;
		}

		/**
		 * parse query get by frontend user check selected options by frontend user
		 *
		 * set $meta_query
		 * set $tax_query
		 * set price_query
		 *
		 * @since 1.0.0, 1.2.8
		 */
		private function parse_query_vars( $selected_options_by_user ) {
			$query_vars   = $selected_options_by_user;
			$tax_query    = array();
			$meta_query   = array();
			$filter_items = Pwf_Filter_Manager::get_filter_items_without_columns( $this->filter_items );

			if ( ! empty( $query_vars ) ) {
				foreach ( $filter_items as $item ) {
					if ( ! isset( $item['url_key'] ) || empty( $item['url_key'] ) ) {
						continue;
					}

					// used if request come from api
					$is_price_item   = false;
					$is_date_item    = false;
					$is_range_slider = false;
					if ( 'priceslider' === $item['item_type'] && 'two' === $item['price_url_format'] ) {
						if ( array_key_exists( $item['url_key_min_price'], $query_vars ) || array_key_exists( $item['url_key_max_price'], $query_vars ) ) {
							$is_price_item = true;
						}
					}

					if ( 'date' === $item['item_type'] ) {
						if ( array_key_exists( $item['url_key_date_after'], $query_vars ) || array_key_exists( $item['url_key_date_before'], $query_vars ) ) {
							$is_date_item = true;
						}
					}

					if ( 'rangeslider' === $item['item_type'] && 'two' === $item['range_slider_url_format'] ) {
						if ( array_key_exists( $item['url_key_range_slider_min'], $query_vars ) || array_key_exists( $item['url_key_range_slider_max'], $query_vars ) ) {
							$is_range_slider = true;
						}
					}

					if ( ( array_key_exists( $item['url_key'], $query_vars ) && ! empty( $query_vars[ $item['url_key'] ] ) ) || $is_price_item || $is_date_item || $is_range_slider ) {
						$url_key = $item['url_key'];
						if ( 'priceslider' !== $item['item_type'] && 'date' !== $item['item_type'] ) {
							$values = $query_vars[ $url_key ];
						}

						if ( 'priceslider' === $item['item_type'] ) {
							if ( 'two' === $item['price_url_format'] ) {
								if ( array_key_exists( $item['url_key_min_price'], $query_vars ) || array_key_exists( $item['url_key_max_price'], $query_vars ) ) {
									$values    = array();
									$min_price = ( $query_vars[ $item['url_key_min_price'] ] ) ?? 0;
									$max_price = ( $query_vars[ $item['url_key_max_price'] ] ) ?? PHP_INT_MAX;
									$values    = array( $min_price, $max_price );
								} elseif ( ! is_array( $query_vars[ $url_key ] ) ) {
									$values = explode( ',', $query_vars[ $url_key ] );
								} else {
									$values = $query_vars[ $url_key ];
								}
							} else {
								if ( ! is_array( $query_vars[ $url_key ] ) ) {
									$values = explode( '-', $query_vars[ $url_key ] );
								} else {
									$values = $query_vars[ $url_key ];
								}
							}
						} elseif ( 'rangeslider' === $item['item_type'] ) {
							if ( 'two' === $item['range_slider_url_format'] ) {
								if ( array_key_exists( $item['url_key_range_slider_min'], $query_vars ) || array_key_exists( $item['url_key_range_slider_max'], $query_vars ) ) {
									$values    = array();
									$min_value = $query_vars[ $item['url_key_range_slider_min'] ];
									$max_value = $query_vars[ $item['url_key_range_slider_max'] ];
									$values    = array( $min_value, $max_value );
								} elseif ( ! is_array( $query_vars[ $url_key ] ) ) {
									$values = explode( ',', $query_vars[ $url_key ] );
								} else {
									$values = $query_vars[ $url_key ];
								}
							} else {
								if ( ! is_array( $query_vars[ $url_key ] ) ) {
									$values = explode( '-', $query_vars[ $url_key ] );
								} else {
									$values = $query_vars[ $url_key ];
								}
							}
						} elseif ( 'date' === $item['item_type'] ) {
							// need to add if request come from ajax or API
							if ( array_key_exists( $item['url_key_date_after'], $query_vars ) || array_key_exists( $item['url_key_date_before'], $query_vars ) ) {
								$after  = $query_vars[ $item['url_key_date_after'] ];
								$before = $query_vars[ $item['url_key_date_before'] ];
								$values = array( $after, $before );
							} elseif ( is_array( $query_vars[ $url_key ] ) ) {
								// from ajax
								$values = $query_vars[ $url_key ];
							}
						} elseif ( ! is_array( $values ) ) {
							$values = explode( ',', $query_vars[ $url_key ] );
						}

						/**
						 * check item price slider with dash split it into array
						 */
						$values = array_map( 'esc_attr', $values );

						if ( 'priceslider' === $item['item_type'] ) {
							if ( count( $values ) === 2 ) {
								$this->has_price_item             = true;
								$values                           = array_map( 'absint', $values );
								$this->price_item_values          = $values;
								$this->selected_items[ $url_key ] = array(
									'values' => $values,
									'type'   => 'price',
								);
								if ( 'two' === $item['price_url_format'] ) {
									array_push( $this->filter_items_key, $item['url_key_min_price'] );
									array_push( $this->filter_items_key, $item['url_key_max_price'] );
									$this->build_query_string( $item['url_key_min_price'], $values[0] );
									$this->build_query_string( $item['url_key_max_price'], $values[1] );
								} else {
									array_push( $this->filter_items_key, $url_key );
									$this->build_query_string( $url_key, $values[0] . '-' . $values[1] );
								}
							}
						} elseif ( 'rangeslider' === $item['item_type'] ) {
							if ( count( $values ) === 2 ) {
								$values = array( floatval( wc_clean( wp_unslash( $values[0] ) ) ), floatval( wc_clean( wp_unslash( $values[1] ) ) ) );
								if ( $values[0] && $values[1] ) {
									if ( 'meta' === $item['source_of_options'] ) {

										if ( 'custom' === $item['range_slider_meta_source'] ) {
											$meta_key = $item['meta_key'];
										} else {
											$meta_key = $item['range_slider_meta_source'];
										}

										$meta = array(
											'key'     => esc_attr( $meta_key ),
											'value'   => $values,
											'compare' => 'BETWEEN',
											'type'    => 'NUMERIC',
										);

										array_push( $meta_query, $meta );

										if ( '_wc_average_rating' === $meta_key ) {
											$rating_ids = array_map( 'absint', $values );
											$rating_ids = range( $values[0], $values[1] );

											$this->selected_items[ $url_key ] = array(
												'values'   => $values,
												'term_ids' => $this->get_rating_term_ids( $rating_ids ),
												'key'      => 'product_visibility',
												'type'     => 'rating',
											);
										} else {
											$this->selected_items[ $url_key ] = array(
												'values' => $values,
												'key'    => $meta_key,
												'type'   => 'rangeslider',
												'title'  => $item['title'], // used with analytic class
											);
										}
									} else {
										$tax = self::get_range_slider_tax_query( $item, $values );
										array_push( $tax_query, $tax );
										$this->selected_items[ $url_key ] = array(
											'values' => $values,
											'key'    => $tax['taxonomy'],
											'type'   => 'taxonomy',
										);
									}

									if ( 'two' === $item['range_slider_url_format'] ) {
										array_push( $this->filter_items_key, $item['url_key_range_slider_min'] );
										array_push( $this->filter_items_key, $item['url_key_range_slider_max'] );
										$this->build_query_string( $item['url_key_range_slider_min'], $values[0] );
										$this->build_query_string( $item['url_key_range_slider_max'], $values[1] );
									} else {
										array_push( $this->filter_items_key, $url_key );
										$this->build_query_string( $url_key, $values[0] . '-' . $values[1] );
									}
								}
							}
						} elseif ( 'date' === $item['item_type'] && count( $values ) === 2 ) {
							$date_from = $values[0];
							$date_to   = $values[1];
							if ( self::check_is_date( $date_from ) && self::check_is_date( $date_to ) ) {
								$year_form  = gmdate( 'Y', strtotime( $date_from ) );
								$month_form = gmdate( 'm', strtotime( $date_from ) );
								$day_form   = gmdate( 'd', strtotime( $date_from ) );
								$year_to    = gmdate( 'Y', strtotime( $date_to ) );
								$month_to   = gmdate( 'm', strtotime( $date_to ) );
								$day_to     = gmdate( 'd', strtotime( $date_to ) );
								$date_query = array(
									'relation' => 'AND',
									array(
										'after'     => array(
											'year'  => absint( $year_form ),
											'month' => absint( $month_form ),
											'day'   => absint( $day_form ),
										),
										'before'    => array(
											'year'  => absint( $year_to ),
											'month' => absint( $month_to ),
											'day'   => absint( $day_to ),
										),
										'inclusive' => true,
									),
								);

								$this->date_query                 = $date_query;
								$this->selected_items[ $url_key ] = array(
									'values' => $values,
									'type'   => 'date',
								);
								array_push( $this->filter_items_key, $item['url_key_date_after'] );
								array_push( $this->filter_items_key, $item['url_key_date_before'] );
								$this->build_query_string( $item['url_key_date_after'], $values[0] );
								$this->build_query_string( $item['url_key_date_before'], $values[1] );
							}
						} elseif ( 'search' === $item['item_type'] ) {
							$this->search_inside = $item['search_inside'];

							$this->search_query               = esc_attr( implode( ' ', $values ) );
							$this->selected_items[ $url_key ] = array(
								'values' => array_map( 'esc_attr', $values ),
								'type'   => 'search',
							);
							array_push( $this->filter_items_key, $url_key );
							$this->build_query_string( $url_key, $this->search_query );
						} elseif ( 'rating' === $item['item_type'] ) {
							$terms           = array();
							$selected_values = $values;
							if ( 'on' === $item['up_text'] ) {
								$selected_values = explode( '-', $values[0] );
								$selected_values = range( $selected_values[0], $selected_values[1] );
								if ( 1 === count( $selected_values ) ) {
									continue;
								}
							}

							$selected_values = array_map( 'absint', $selected_values );
							$terms           = $this->get_rating_term_ids( $selected_values );

							$tax = array(
								'taxonomy'      => 'product_visibility',
								'field'         => 'term_taxonomy_id',
								'terms'         => $terms,
								'operator'      => 'IN',
								'rating_filter' => true,
							);
							array_push( $tax_query, $tax );

							if ( 'on' === $item['up_text'] ) {
								$values = array( esc_attr( $values[0] ) );
							} else {
								$values = array_map( 'absint', $values );
							}

							$this->selected_items[ $url_key ] = array(
								'values'   => $values,
								'term_ids' => $terms,
								'key'      => 'product_visibility',
								'type'     => 'rating',
							);
							array_push( $this->filter_items_key, $url_key );
							$this->build_query_string( $url_key, implode( ',', $values ) );
						} elseif ( 'stock_status' === $item['source_of_options'] ) {
							if ( 1 < count( $values ) ) {
								// Maybe end user select instock and outstock
								$this->stock_status = 'none';
							} else {
								if ( in_array( 'instock', $values, true ) ) {
									$this->stock_status = 'instock';
								} else {
									$this->stock_status = 'outofstock';
								}
							}

							$this->selected_items[ $url_key ] = array(
								'values' => $values,
								'type'   => 'stock_status',
							);
							array_push( $this->filter_items_key, $url_key );
							$this->build_query_string( $url_key, implode( ',', $values ) );
						} elseif ( 'meta' === $item['source_of_options'] ) {
							$meta_values = $this->get_meta_values( $values, $item );
							if ( ! empty( $meta_values ) ) {
								$selected_meta = array();
								foreach ( $meta_values as $meta_option ) {
									$selected_meta[] = array(
										'key'     => $item['meta_key'],
										'value'   => $meta_option['value'],
										'compare' => $item['meta_compare'],
										'type'    => $item['meta_type'],
									);
								}
								if ( count( $meta_values ) > 1 ) {
									if ( isset( $item['query_type'] ) && 'or' !== $item['query_type'] ) {
										$selected_meta['relation'] = 'AND';
									} else {
										$selected_meta['relation'] = 'OR';
									}
								}

								$this->selected_items[ $url_key ] = array(
									'values'          => $values,
									'key'             => $item['meta_key'],
									'type'            => 'meta',
									'selected_values' => $meta_values,
									'title'           => $item['title'], // used with analytic class
								);

								/**
								 * If meta is rating manipulate it as taxonomy for analytic data
								 */
								if ( '_wc_average_rating' === $item['meta_key'] ) {
									if ( strpos( $values[0], '-' ) !== false ) {
										$values = explode( '-', $values[0] );
										$values = range( $values[0], $values[1] );
									}

									$values = array_map( 'absint', $values );

									$this->selected_items[ $url_key ]['term_ids'] = $this->get_rating_term_ids( $values );
									$this->selected_items[ $url_key ]['key']      = 'product_visibility';
									$this->selected_items[ $url_key ]['type']     = 'rating';
								}
								array_push( $meta_query, $selected_meta );
								array_push( $this->filter_items_key, $url_key );
								$this->build_query_string( $url_key, implode( ',', $values ) );
							}
						} elseif ( 'orderby' === $item['source_of_options'] ) {
							$this->orderby                    = $values;
							$this->selected_items[ $url_key ] = array(
								'values' => $values,
								'type'   => 'orderby',
							);
							array_push( $this->filter_items_key, $url_key );
							$this->build_query_string( $url_key, implode( ',', $values ) );
						} elseif ( 'author' === $item['source_of_options'] ) {
							$values                           = array_map( 'absint', $values );
							$this->authors_id                 = array_merge( $this->authors_id, $values );
							$this->selected_items[ $url_key ] = array(
								'values' => $values,
								'type'   => 'vendor',
							);
							array_push( $this->filter_items_key, $url_key );
							$this->build_query_string( $url_key, implode( ',', $this->get_users_nicename( $values ) ) );
						} elseif ( 'featured' === $item['source_of_options'] ) {
							if ( is_int( $values[0] ) ) {
								$values = array_map( 'absint', $values );
							} else {
								// if values come from url directly
								$product_visibility_term_ids = wc_get_product_visibility_term_ids();
								$values                      = array( absint( $product_visibility_term_ids['featured'] ) );
							}

							$tax = array(
								'taxonomy' => 'product_visibility',
								'field'    => 'term_taxonomy_id',
								'terms'    => $values,
								'operator' => 'IN',
							);

							$this->selected_items[ $url_key ] = array(
								'values' => $values,
								'key'    => 'product_visibility',
								'type'   => 'taxonomy',
							);
							array_push( $tax_query, $tax );
							array_push( $this->filter_items_key, $url_key );
							$this->build_query_string( $url_key, 'yes' );
						} elseif ( 'on_sale' === $item['source_of_options'] ) {
							if ( 'yes' === $values[0] ) {
								$this->has_on_sale = true;

								$this->selected_items[ $url_key ] = array(
									'values' => array( 'yes' ),
									'key'    => 'on_sale',
									'type'   => 'on_sale',
								);
								array_push( $this->filter_items_key, $url_key );
								$this->build_query_string( $url_key, 'yes' );
							}
						} else {
							$operator = 'IN';
							if ( isset( $item['query_type'] ) && 'or' !== $item['query_type'] ) {
								$operator = 'AND';
							}

							if ( 'category' === $item['source_of_options'] ) {
								$taxonomy = 'product_cat';
							} elseif ( 'attribute' === $item['source_of_options'] ) {
								$taxonomy = $item['item_source_attribute'];
							} elseif ( 'taxonomy' === $item['source_of_options'] ) {
								$taxonomy = $item['item_source_taxonomy'];
							} elseif ( 'tag' === $item['source_of_options'] ) {
								$taxonomy = 'product_tag';
							}

							$values = $this->check_is_multiselect( $item, $values );
							$values = array_map( 'absint', $this->convert_terms_slug_to_id( $values, $taxonomy ) );
							$tax    = array(
								'taxonomy'         => $taxonomy,
								'field'            => 'term_id',
								'terms'            => $values,
								'operator'         => $operator,
								'include_children' => true,
							);

							if ( 'attribute' === $item['source_of_options'] ) {
								if ( isset( $item['product_variations'] ) && 'on' === $item['product_variations'] ) {
									if ( Pwf_Main::is_plugin_activated() || Pwf_Main::is_development_site() ) {
										array_push( $this->outofstock_terms, $tax );
									}
								}
							}

							$this->selected_items[ $url_key ] = array(
								'values' => $values,
								'key'    => $taxonomy,
								'type'   => 'taxonomy',
							);
							array_push( $this->filter_items_key, $url_key );
							array_push( $tax_query, $tax );
							$this->build_query_string( $url_key, implode( ',', $this->convert_term_ids_to_slug( $values, $taxonomy ) ) );
						}
					}
				}
			}

			$this->tax_query_items = $tax_query;
			$this->tax_query       = $this->append_custom_tax_query( $tax_query );
			$this->meta_query      = $this->append_custom_meta_query( $meta_query );
		}

		/**
		 * Count number of values and return one or more depend on field type and multi select
		 * Reutn values array depend on filter type and multi select
		 */
		private function check_is_multiselect( $item, $values ) {
			if ( 'radiolist' === $item['item_type'] ) {
				// return array contain one value
				if ( is_array( $values ) ) {
					if ( 1 === count( $values ) ) {
						return $values;
					} else {
						return array( $values[0] );
					}
				} else {
					return array( $values );
				}
			}

			$multiselect_fields = array( 'colorlist', 'boxlist', 'textlist' );
			if ( in_array( $item['item_type'], $multiselect_fields, true ) && 'on' !== $item['multi_select'] ) {
				if ( is_array( $values ) ) {
					return array( $values[0] );
				} else {
					return array( $values );
				}
			}

			return $values;
		}

		private function convert_terms_slug_to_id( $terms, $taxonomy ) {
			$the_terms = array();
			if ( ! is_numeric( $terms[0] ) ) {
				foreach ( $terms as $term ) {
					$the_term = get_term_by( 'slug', $term, $taxonomy );
					if ( false !== $the_term ) {
						$the_terms[] = $the_term->term_id;
					}
				}
				$terms = $the_terms;
			} else {
				// check if the term slug is number not string useful for size taxonomy is number
				$check_term_exist = get_term_by( 'slug', $terms[0], $taxonomy );
				if ( false !== $check_term_exist ) {
					foreach ( $terms as $term ) {
						$the_term = get_term_by( 'slug', $term, $taxonomy );
						if ( false !== $the_term ) {
							$the_terms[] = $the_term->term_id;
						}
					}
					$terms = $the_terms;
				}
			}

			return $terms;
		}

		/**
		* @param string
		*
		* @return bool
		*/
		private static function check_is_date( $date ) {
			if ( false !== DateTime::createFromFormat( 'Y-m-d', $date ) ) {
				return true;
			} else {
				return false;
			}
		}

		/**
		 * Integrate Woocommerce shortcode with counted terms and product loop
		 *
		 * @since version 1.1.2, 1.3.8, 1.6.6
		 */
		public function integrate_woo_shortcode( $filter_id ) {

			if ( 'product' === $this->post_type && 'custom_query' === $this->filter_setting['filter_query_type'] ) {
				if ( ! empty( $this->filter_setting['shortcode_string'] ) ) {
					$defaults = Pwf_Woo_Utilities::get_woo_shortcode_default_attrs();
					$atts     = Pwf_Woo_Utilities::extract_shortcode_attrs( $this->filter_setting['shortcode_string'] );
					if ( ! empty( $atts ) && is_array( $atts ) ) {
						$atts = wp_parse_args( $atts, $defaults );
						new Pwf_Integrate_Woo_Shortcode( $filter_id, $atts );
					}
				}
			}
		}

		/**
		 * Get taxonmy query for range slider
		 *
		 * @since 1.1.4
		 *
		 * @param array $filteritem filter item options
		 * @param array $values selected values for filter item
		 *
		 * @return array taxonomy query
		 */
		public static function get_range_slider_tax_query( $filter_item, $values ) {
			$used_terms   = array();
			$min_value    = $values[0];
			$max_value    = $values[1];
			$item_display = $filter_item['item_display'] ?? '';

			if ( 'attribute' === $filter_item['source_of_options'] ) {
				$taxonomy = $filter_item['item_source_attribute'];
			} elseif ( 'taxonomy' === $filter_item['source_of_options'] ) {
				$taxonomy = $filter_item['item_source_taxonomy'];
			}

			$args = array(
				'taxonomy'   => esc_attr( $taxonomy ),
				'hide_empty' => true,
			);

			if ( 'selected' === $item_display && ! empty( $item['include'] ) ) {
				$args['include'] = array_map( 'absint', $item['include'] );
				$args['include'] = Pwf_Wpml::convert_include_term_ids_to_translated_term_ids( $args['include'], $args['taxonomy'] );
			} elseif ( 'except' === $item_display && ! empty( $item['exclude'] ) ) {
				$exclude_ids = array_map( 'absint', $item['exclude'] );
				$exclude_ids = Pwf_Wpml::convert_include_term_ids_to_translated_term_ids( $exclude_ids, $args['taxonomy'] );

				$term_ids = get_terms(
					array(
						'taxonomy'   => $args['taxonomy'],
						'hide_empty' => false,
						'fields'     => 'ids',
					)
				);
				foreach ( $term_ids as $key => $term_id ) {
					if ( in_array( $term_id, $exclude_ids, true ) ) {
						unset( $term_ids[ $key ] );
					}
				}
				$args['include'] = $term_ids;
			}

			$terms = get_terms( $args );
			foreach ( $terms as $term ) {
				if ( $term->name >= $min_value && $term->name <= $max_value ) {
					array_push( $used_terms, $term->term_id );
				}
			}

			$tax_query = array(
				'taxonomy' => esc_attr( $taxonomy ),
				'field'    => 'term_id',
				'terms'    => $used_terms,
				'operator' => 'IN',
			);

			return $tax_query;
		}

		/**
		 * Processing the user selected metas to Understandable values to WordPress
		 *
		 * @param array $slugs realted to end user selected values
		 * @param array $item represnt meta field
		 *
		 * @since 1.2.4
		 * @return array foreach meta option with values, value maybe string or array
		 */
		private function get_meta_values( $slugs, $item ) {
			$result         = array();
			$value_is_array = array( 'IN', 'NOT IN', 'BETWEEN', 'NOT BETWEEN' );
			$numeric_tyepe  = array( 'NUMERIC', 'DECIMAL', 'SIGNED', 'UNSIGNED' );
			$meta_data      = $item['metafield'];

			foreach ( $meta_data as $meta ) {
				if ( ! isset( $meta['slug'] ) ) {
					$meta['slug'] = $meta['value']; // fix version before 1.2.2
				}
				if ( in_array( $meta['slug'], $slugs, true ) ) {
					if ( in_array( $item['meta_compare'], $value_is_array, true ) ) {
						$value = explode( ',', $meta['value'] );

						if ( in_array( $item['meta_type'], $numeric_tyepe, true ) ) {
							$value = array_map( 'floatval', $value );
						} else {
							$value = array_map( 'esc_attr', $value );
						}
					} else {
						if ( in_array( $item['meta_type'], $numeric_tyepe, true ) ) {
							$value = floatval( $meta['value'] );
						} else {
							$value = esc_attr( $meta['value'] );
						}
					}

					$result[] = array(
						'slug'  => $meta['slug'],
						'value' => $value,
						'label' => $meta['label'], // used with analytic class
					);
				}
			}
			return $result;
		}

		/**
		 * Get ids for the rating
		 * If meta or range slider is rating
		 * manipulate it as taxonomy for analytic data
		 *
		 * @since 1.2.8
		 *
		 * @return Array For rating term ID
		 */
		private function get_rating_term_ids( $values ) {
			$terms                    = array();
			$product_visibility_terms = wc_get_product_visibility_term_ids();
			foreach ( $values as $value ) {
				array_push( $terms, $product_visibility_terms[ 'rated-' . $value ] );
			}

			return $terms;
		}

		protected function build_query_string( $url_key, $value ) {
			$this->query_string[] = $url_key . '=' . $value;
		}

		protected function get_users_nicename( $ids ) {
			$users = get_users(
				array(
					'include' => $ids,
					'fields'  => array( 'user_nicename' ),
				)
			);

			$nice_names = array();
			foreach ( $users as $user ) {
				array_push( $nice_names, $user->user_nicename );
			}

			return $nice_names;
		}

		protected function convert_term_ids_to_slug( $values, $taxonomy_name ) {
			$slugs = get_terms(
				array(
					'taxonomy' => $taxonomy_name,
					'include'  => $values,
					'fields'   => 'slugs',
				)
			);

			return $slugs;
		}

		/**
		 * Get out of stock products IDS foreach product variations
		 * @since 1.4.8, 1.6.6
		 *
		 * @return array product_ids
		 */
		protected function set_out_of_stock_product_variations_ids() {
			if ( empty( $this->outofstock_terms ) ) {
				return;
			}

			$product_variations   = new Pwf_Woo_Product_Variations( $this->outofstock_terms, $this );
			$this->outofstock_ids = $product_variations->get_out_of_stock_ids();

			if ( ! empty( $this->outofstock_ids ) && 'none' === $this->stock_status ) {
				$this->stock_status = 'active';
			}
		}
	}
}
