<?php

defined( 'ABSPATH' ) || exit;

if ( ! class_exists( 'Pwf_Admin_Main' ) ) {

	/**
	 * Enahancement admin
	 * @since 1.5.5
	 */
	class Pwf_Admin_Main {

		function __construct() {
			add_action( 'admin_init', array( $this, 'admin_init' ), 10 );
			add_action( 'admin_enqueue_scripts', array( $this, 'remove_auto_save_script' ) );
			add_action( 'manage_pwf_woofilter_posts_custom_column', array( $this, 'fill_filter_post_type_columns' ), 10, 2 );
			add_filter( 'manage_pwf_woofilter_posts_columns', array( $this, 'render_filter_post_columns' ) );

			// Edit filter post
			add_action( 'admin_enqueue_scripts', array( $this, 'filter_post_enqueue_scripts_styles' ), 10 );
			add_action( 'wp_ajax_get_hierarchy_taxonomies_using_ajax', array( $this, 'get_hierarchy_taxonomies_using_ajax' ) );
			add_action( 'wp_ajax_get_group_taxonomies_using_ajax', array( $this, 'get_group_taxonomies_using_ajax' ) );
			add_action( 'wp_ajax_get_taxonomies_using_ajax', array( $this, 'get_taxonomies_using_ajax' ) );
			add_action( 'wp_ajax_save_filter_post', array( $this, 'save_filter_post' ) );

			// For Analytic page
			if ( Pwf_Main::is_plugin_activated() || Pwf_Main::is_development_site() ) {
				add_action( 'admin_menu', array( $this, 'create_analytic_page' ), 100 );
				add_action( 'wp_ajax_get_ajax_analytic_data_result', array( $this, 'get_ajax_analytic_data_result' ), 10 );
			}
		}

		public function filter_post_enqueue_scripts_styles() {
			global $pagenow, $post;
			if ( ! empty( $pagenow ) && 'post-new.php' === $pagenow || 'post.php' === $pagenow ) {
				if ( 'pwf_woofilter' === $post->post_type ) {
					new Pwf_Meta();
				}
			}
		}

		public function get_hierarchy_taxonomies_using_ajax() {
			$pwf_meta = new Pwf_Meta();
			$pwf_meta->get_hierarchy_taxonomies_using_ajax();
		}

		public function get_group_taxonomies_using_ajax() {
			$pwf_meta = new Pwf_Meta();
			$pwf_meta->get_group_taxonomies_using_ajax();
		}

		public function get_taxonomies_using_ajax() {
			$pwf_meta = new Pwf_Meta();
			$pwf_meta->get_taxonomies_using_ajax();
		}

		public function save_filter_post() {
			$pwf_meta = new Pwf_Meta();
			$pwf_meta->save_filter_post();
		}

		public function create_analytic_page() {
			$submenu = add_submenu_page(
				'wc-admin&path=/analytics/overview',
				'Anyalytic Filters',
				'Filters',
				'manage_options',
				'pwf-filters',
				array( $this, 'render_analytic_page' )
			);

			add_action( 'admin_print_styles-' . $submenu, array( $this, 'analytic_page_enqueue_styles' ) );
			add_action( 'admin_print_scripts-' . $submenu, array( $this, 'analytic_page_enqueue_scripts' ) );
		}

		public function render_analytic_page() {
			$analytic = new Pwf_Analytic_Page();
			$analytic->render_analytic_page();
		}

		public function analytic_page_enqueue_styles() {
			Pwf_Analytic_Page::admin_settings_enqueue_styles();
		}

		public function analytic_page_enqueue_scripts() {
			$analytic = new Pwf_Analytic_Page();
			$analytic->admin_settings_enqueue_scripts();
		}

		public function get_ajax_analytic_data_result() {
			$analytic = new Pwf_Analytic_Page();
			$analytic->get_ajax_analytic_data_result();
		}

		public function remove_auto_save_script() {
			switch ( get_post_type() ) {
				case 'pwf_woofilter':
					wp_dequeue_script( 'autosave' );
					break;
			}
		}

		public function fill_filter_post_type_columns( $column, $post_id ) {
			if ( 'pwfshortcode' === $column ) {
				echo '[pwf_filter id="' . absint( $post_id ) . '"]';
			}
			if ( 'pwfquerytype' === $column ) {
				$meta       = get_post_meta( absint( $post_id ), '_pwf_woo_post_filter', true );
				$settings   = $meta['setting'];
				$query_type = $settings['filter_query_type'] ?? '';
				if ( ! empty( $query_type ) ) {
					if ( 'main_query' === $query_type ) {
						$text = esc_html__( 'Main Query', 'pwf-woo-filter' );
					} else {
						$text = esc_html__( 'Custom Query', 'pwf-woo-filter' );
					}
					echo '<strong>' . $text . '</strong>';
				}
			}
			if ( 'pwfpages' === $column ) {
				$meta       = get_post_meta( absint( $post_id ), '_pwf_woo_post_filter', true );
				$settings   = $meta['setting'];
				$query_type = $settings['filter_query_type'] ?? '';
				if ( ! empty( $query_type ) ) {
					if ( 'main_query' === $query_type ) {
						$pages = self::get_filter_archive_pages( $post_id );
						echo $pages;
					} else {
						$pages = self::get_filter_pages( $post_id );
						echo $pages;
					}
				}
			}
		}

		/**
		 * @since 1.5.4
		 */
		protected static function get_filter_archive_pages( $filter_id ) {
			$archive_pages = array();
			$pages         = get_option( 'pwf_woo_main_query_filters', '' );

			if ( ! empty( $pages ) ) {
				$results = array();
				foreach ( $pages as $key => $value ) {
					if ( $filter_id === $value ) {
						array_push( $results, $key );
					}
				}

				if ( ! empty( $results ) ) {
					foreach ( $results as $term ) {
						if ( 'shop_archive' === $term ) {
							array_push( $archive_pages, '<strong>Shop Archive</strong>' );
						} else {
							$split    = explode( '__', $term );
							$tax_name = $split[0];
							$term_id  = $split[1];
							if ( 'all' === $term_id ) {
								$taxonomy = get_taxonomy( esc_attr( $tax_name ) );
								if ( ! is_wp_error( $taxonomy ) ) {
									array_push( $archive_pages, 'All ' . $taxonomy->label );
								}
							} else {
								$term = get_term( absint( $term_id ), esc_attr( $tax_name ) );
								if ( ! is_wp_error( $term ) ) {
									array_push( $archive_pages, $term->name );
								}
							}
						}
					}
				}
			}

			if ( ! empty( $archive_pages ) ) {
				$archive_pages = implode( ', ', $archive_pages );
			} else {
				$archive_pages = '';
			}

			return $archive_pages;
		}

		/**
		 * @since 1.5.4
		 */
		protected static function get_filter_pages( $filter_id ) {
			$pages        = array();
			$filter_pages = get_option( 'pwf_woo_custom_query_filters', '' );

			if ( ! empty( $filter_pages ) ) {
				$results = array();
				foreach ( $filter_pages as $key => $value ) {
					if ( absint( $value ) === $filter_id ) {
						array_push( $results, $key );
					}
				}
				if ( ! empty( $results ) ) {
					foreach ( $results as $page_id ) {
						$page = get_post( absint( $page_id ) );
						array_push( $pages, $page->post_title );
					}
				}
			}

			if ( ! empty( $pages ) ) {
				$pages = implode( ', ', $pages );
			} else {
				$pages = '';
			}

			return $pages;
		}

		public function render_filter_post_columns( $columns ) {
			$date = $columns['date'];
			unset( $columns['date'] );
			$columns['pwfshortcode'] = 'Shortcode';
			$columns['pwfquerytype'] = 'Query Type';
			$columns['pwfpages']     = 'Pages';
			$columns['date']         = $date;

			return $columns;
		}

		public function admin_init() {
			self::plugin_version();
		}

		/**
		 * @since 1.2.7, 1.5.5
		 */
		public static function plugin_version() {
			$version = get_option( 'pwf_woocommerce_version' );
			if ( false !== $version && version_compare( $version, PWF_WOO_FILTER_VER, '<' ) ) {
				self::do_update();
				update_option( 'pwf_woocommerce_version', PWF_WOO_FILTER_VER );
				if ( ! Pwf_Main::is_plugin_activated() ) {
					delete_transient( 'dismissed_plugin_pwf_woo_filter' );
				}
			} elseif ( false === $version ) {
				update_option( 'pwf_woocommerce_version', PWF_WOO_FILTER_VER );
			}
		}

		/**
		 * since 1.5.7
		 */
		protected static function do_update() {
			$version = get_option( 'pwf_woocommerce_version' );

			self::update_purchase_code();

			$filter_id = get_option( 'pwf_shop_filter_id', '' );
			if ( ! empty( $filter_id ) ) {
				$udpate = new pwf_update( array( 'update_filter_post' ) );
			}

			if ( false !== $version && version_compare( $version, '1.5.7', '<' ) ) {
				$udpate = new pwf_update( array( 'add_pretty_urls' ) );
			}
		}

		/**
		 * @since 1.4.4, 1.5.7
		 */
		private static function update_purchase_code() {
			$purchase_code = get_option( 'envato_purchase_code_28181010' );
			if ( false !== $purchase_code && ! empty( $purchase_code ) ) {
				self::set_purchase_code( $purchase_code );
			}
			delete_option( 'envato_purchase_code_28181010' );
		}

		public static function set_purchase_code( $purchase_code ) {
			if ( Pwf_Main::check_is_network_plugin() ) {
				update_site_option( 'envato_purchase_code_pwf_28181010', esc_attr( $purchase_code ) );
			} else {
				update_option( 'envato_purchase_code_pwf_28181010', esc_attr( $purchase_code ) );
			}
		}

	}

	new Pwf_Admin_Main();
}
