<?php

defined( 'ABSPATH' ) || exit;

if ( ! class_exists( 'Pwf_Routes_Manager' ) ) {
	/**
	 * Manage all routes pretty links on one place
	 *
	 * @since 1.5.7
	 */
	class Pwf_Routes_Manager {

		function __construct() {}

		/**
		 * Update routes saved in options
		 *
		 * @param int $filter_id
		 */
		public static function update_routes( $filter_id ) {
			$routes = self::get_routes();

			if ( absint( $filter_id ) ) {
				$routes = self::add_singel_route( absint( $filter_id ), $routes );
			}

			self::set_routes( $routes );
		}

		/**
		 * Regenerates routes
		 */
		public static function regenerates_routes() {
			$routes     = array(); // set empty to regenerate new routes
			$query_args = array(
				'post_type'      => 'pwf_woofilter',
				'post_status'    => 'publish',
				'posts_per_page' => -1,
			);

			$filters = get_posts( $query_args );
			if ( $filters ) {
				foreach ( $filters as $filter ) {
					$routes = self::add_singel_route( absint( $filter->ID ), $routes );
				}
			}

			self::set_routes( $routes );
		}

		private static function get_routes() {
			$routes = get_option( 'pwf_woo_filter_routes', null );
			if ( null === $routes ) {
				$routes = array();
			}

			return $routes;
		}

		/**
		 * Save routes in DB
		 */
		private static function set_routes( $routes ) {
			if ( ! empty( $routes ) ) {
				update_option( 'pwf_woo_filter_routes', $routes, 'yes' );
			}
		}

		/**
		 * Extract route separator from item depend on item type and query_type
		 *
		 * @since 1.5.7
		 *
		 * @return string separator
		 */
		private static function get_route_separator( array $item ) {
			$separator = 'and'; // Default value

			switch ( $item['item_type'] ) {
				case 'checkboxlist':
					if ( 'featured' === $item['source_of_options'] || 'on_sale' === $item['source_of_options'] ) {
						$separator = '';
					} else {
						$separator = 'or';
					}
					break;
				case 'radiolist':
					if ( 'orderby' === $item['source_of_options'] ) {
						$separator = '';
					}
					break;
				case 'textlist':
				case 'boxlist':
				case 'colorlist':
				case 'dropdownlist':
					if ( isset( $item['query_type'] ) ) {
						$separator = strtolower( esc_attr( $item['query_type'] ) );
					}
					break;
				case 'date':
				case 'priceslider':
				case 'rangeslider':
					$separator = 'to';
					break;
				case 'search':
					$separator = 'for';
					break;
				case 'rating':
					if ( 'on' === $item['up_text'] ) {
						$separator = 'to';
					}
					break;
			}

			return $separator;
		}

		/**
		 * Add route to routes array
		 *
		 * @param int $filter_id
		 * @param array $routes
		 *
		 * @since 1.5.7
		 *
		 * return array $routes
		 */
		private static function add_singel_route( int $filter_id, array $routes ) {
			$filter = get_post_meta( $filter_id, '_pwf_woo_post_filter', true );
			$items  = $filter['items'];
			if ( ! empty( $items ) ) {
				$items = Pwf_Filter_Manager::get_filter_items_without_columns( $items );
				foreach ( $items as $item ) {
					$url_key = $item['url_key'];
					if ( ! isset( $routes[ $url_key ] ) ) {
						$routes[ $url_key ] = array(
							'title'     => $item['title'],
							'separator' => self::get_route_separator( $item ),
						);
					}
				}
			}

			return $routes;
		}
	}
}
