<?php

defined( 'ABSPATH' ) || exit;

if ( ! class_exists( 'Pwf_Generate_Css' ) ) {

	class Pwf_Generate_Css {

		protected static $file_name = 'pwf-woo-customizer.css';

		public function __construct() {}

		public function css_file( $css_options ) {
			self::upload_wp_class_file();
			global $wp_filesystem;
			WP_Filesystem();

			$css_file_path = self::get_css_file_path();

			if ( $wp_filesystem->exists( $css_file_path ) ) {
				self::enqueue_style();
				return true;
			} else {
				// Save file and set permission to 0644
				$style       = self::get_css( $css_options );
				$create_file = $wp_filesystem->put_contents( $css_file_path, $style, 0644 );
				if ( $create_file ) {
					self::enqueue_style();
					return true;
				} else {
					wp_add_inline_style( 'pwf-woo-filter', $style );
				}
			}
		}

		public static function delete_css_file() {
			self::upload_wp_class_file();
			global $wp_filesystem;
			WP_Filesystem();

			$css_file_path = self::get_css_file_path();

			$delete = $wp_filesystem->delete( $css_file_path );
			if ( ! $delete ) {
				error_log( 'CSS file generated by customizer can not deleted' );
			}
		}

		protected static function upload_wp_class_file() {
			require_once( ABSPATH . 'wp-admin/includes/file.php' );
		}

		protected static function enqueue_style() {
			$upload_dir = wp_upload_dir();
			$file       = trailingslashit( $upload_dir['baseurl'] ) . self::$file_name;
			wp_enqueue_style( 'pwf-woo-filter-customizer', $file, array( 'pwf-woo-filter' ), PWF_WOO_FILTER_VER );
		}

		protected static function get_css_file_path() {
			$upload_dir = wp_upload_dir();
			$directory  = trailingslashit( $upload_dir['basedir'] );
			return $directory . self::$file_name;
		}

		protected static function get_css( $options ) {
			$style = '';
			foreach ( $options as $key => $value ) {
				if ( ! empty( $value ) ) {
					$style .= self::generate_css_selectors( $key, $value, $options );
				}
			}

			return $style;
		}

		protected static function generate_css_selectors( $key, $value, $options ) {
			$css = '';
			switch ( $key ) {
				case 'filter_bg':
					$css = '.pwf-woo-filter { background-color:' . sanitize_hex_color( $value ) . ';}';
					break;
				case 'title_color':
					$css = '.pwf-field-item-title,.pwf-field-item-title .pwf-toggle{ color:' . sanitize_hex_color( $value ) . ';}';
					break;
				case 'title_font_size':
					$css = '.pwf-field-item-title, .pwf-field-item-title .pwf-toggle::before{ font-size:' . absint( $value ) . 'px;}';
					break;
				case 'title_font_weight':
					$css = '.pwf-field-item-title,.pwf-field-item-title .pwf-toggle{ font-weight:' . absint( $value ) . ';}';
					break;
				case 'title_margin_bottom':
					$css = '.pwf-field-item-title{ margin-bottom:' . intval( $value ) . 'px;}';
					break;
				case 'title_border_status':
					break;
				case 'title_padding_bottom':
					if ( 'on' === $options['title_border_status'] ) {
						$css = '.pwf-field-item-title{ padding-bottom:' . intval( $value ) . 'px;}';
					}
					break;
				case 'title_border_color':
					if ( 'on' === $options['title_border_status'] ) {
						$css = '.pwf-field-item-title{ border-bottom-color:' . sanitize_hex_color( $value ) . ';border-bottom-style: solid;}';
					}
					break;
				case 'title_border_width':
					if ( 'on' === $options['title_border_status'] ) {
						$css = '.pwf-field-item-title{ border-bottom-width:' . absint( $value ) . 'px;}';
					}
					break;
				case 'af_font_size':
					$css = '.pwf-note-item{font-size:' . absint( $value ) . 'px;}';
					break;
				case 'af_line_height':
					$css = '.pwf-note-item{line-height:' . absint( $value ) . 'px;}';
					break;
				case 'af_border_width':
					$css = '.pwf-note-item{border-width:' . absint( $value ) . 'px;}';
					break;
				case 'af_border_radius':
					$css = '.pwf-note-item{border-radius:' . absint( $value ) . 'px;}';
					break;
				case 'af_text_color':
					$css  = '.pwf-icon-remove::before{ background-color:' . sanitize_hex_color( $value ) . ';}';
					$css .= '.pwf-note-item{ color:' . sanitize_hex_color( $value ) . ';}';
					break;
				case '_af_bg_color':
					$css = '.pwf-note-item{ background-color:' . sanitize_hex_color( $value ) . ';}';
					break;
				case 'af_border_color':
					$css = '.pwf-note-item{ border-color:' . sanitize_hex_color( $value ) . ';}';
					break;
				case 'af_text_hover_color':
					$css = '.pwf-note-item:hover{ color:' . sanitize_hex_color( $value ) . ';}';
					break;
				case 'af_bg_hover_color':
					$css = '.pwf-note-item:hover{ background-color:' . sanitize_hex_color( $value ) . ';}';
					break;
				case 'af_border_hover_color':
					$css = '.pwf-note-item:hover{ border-color:' . sanitize_hex_color( $value ) . ';}';
					break;
				case 'boxlist_margin':
					$css = '.pwf-boxlist-item{ margin-right:' . intval( $value ) . 'px;margin-top:' . intval( $value ) . 'px;}';
					$css = '.pwf-boxlist-item{ margin:' . intval( $value ) . 'px 0 0 ' . intval( $value ) . 'px;}';
					break;
				case 'boxlist_font_size':
					$css = self::get_boxlist_lable_selector() . '{ font-size:' . absint( $value ) . 'px;}';
					break;
				case 'boxlist_font_weight':
					$css = self::get_boxlist_lable_selector() . '{ font-weight:' . absint( $value ) . ';}';
					break;
				case 'boxlist_border_width':
					$css = '.pwf-boxlist-item{ border-width:' . absint( $value ) . 'px;}';
					break;
				case 'boxlist_border_radius':
					$css = '.pwf-boxlist-item{ border-radius:' . absint( $value ) . 'px;}';
					break;
				case 'boxlist_text_color':
					$css = self::get_boxlist_lable_selector() . '{ color:' . sanitize_hex_color( $value ) . ';}';
					break;
				case 'boxlist_text_hover_color':
					$css  = '.pwf-boxlist-item.selected .pwf-item-label .pwf-title-container .text-title,';
					$css .= '.pwf-boxlist-item:hover .pwf-item-label .pwf-title-container .text-title{ color:' . sanitize_hex_color( $value ) . ';}';
					break;
				case 'boxlist_bg_color':
					$css = '.pwf-boxlist-item{ background-color:' . sanitize_hex_color( $value ) . ';}';
					break;
				case 'boxlist_bg_hover_color':
					$css = '.pwf-boxlist-item.selected, .pwf-boxlist-item:hover { background-color:' . sanitize_hex_color( $value ) . ';}';
					break;
				case 'boxlist_border_color':
					$css = '.pwf-boxlist-item{ border-color:' . sanitize_hex_color( $value ) . ';}';
					break;
				case 'boxlist_border_hover_color':
					$css = '.pwf-boxlist-item.selected, .pwf-boxlist-item:hover { border-color:' . sanitize_hex_color( $value ) . ';}';
					break;
				case 'boxlist_count_font_size':
					$css = '.pwf-boxlist-item .pwf-product-counts{ font-size:' . absint( $value ) . 'px;}';
					break;
				case 'boxlist_count_font_weight':
					$css = '.pwf-boxlist-item .pwf-product-counts{ font-weight:' . absint( $value ) . ';}';
					break;
				case 'boxlist_count_text_color':
					$css = '.pwf-boxlist-item .pwf-product-counts{ color:' . sanitize_hex_color( $value ) . ';}';
					break;
				case 'boxlist_count_text_hover_color':
					$css  = '.pwf-boxlist-item.selected .pwf-product-counts,';
					$css .= '.pwf-boxlist-item:hover .pwf-product-counts { color:' . sanitize_hex_color( $value ) . ';}';
					break;
				case 'boxlist_count_bg_color':
					$css = '.pwf-boxlist-item .pwf-product-counts{ background-color:' . sanitize_hex_color( $value ) . ';}';
					break;
				case 'boxlist_count_hover_bg_color':
					$css  = '.pwf-boxlist-item.selected .pwf-product-counts,';
					$css .= '.pwf-boxlist-item:hover .pwf-product-counts { background-color:' . sanitize_hex_color( $value ) . ';}';
					break;
				case 'button_font_size':
					$css = '.pwf-field-item-button .pwf-item-button{ font-size:' . absint( $value ) . 'px;}';
					break;
				case 'button_font_weight':
					$css = '.pwf-field-item-button .pwf-item-button{ font-weight:' . absint( $value ) . ';}';
					break;
				case 'button_border_radius':
					$css = '.pwf-field-item-button .pwf-item-button{ border-radius:' . absint( $value ) . 'px;}';
					break;
				case 'button_color':
					$css = '.pwf-field-item-button .pwf-item-button{ color:' . sanitize_hex_color( $value ) . ';}';
					break;
				case 'button_bg_color':
					$css = '.pwf-field-item-button .pwf-item-button{ background-color:' . sanitize_hex_color( $value ) . ';}';
					break;
				case 'button_border_color':
					$css = '.pwf-field-item-button .pwf-item-button{ border-color:' . sanitize_hex_color( $value ) . ';}';
					break;
				case 'button_hover_color':
					$css = '.pwf-field-item-button .pwf-item-button:hover{ color:' . sanitize_hex_color( $value ) . ';}';
					break;
				case 'button_bg_hover_color':
					$css = '.pwf-field-item-button .pwf-item-button:hover{ background-color:' . sanitize_hex_color( $value ) . ';}';
					break;
				case 'button_border_hover_color':
					$css = '.pwf-field-item-button .pwf-item-button:hover{ border-color:' . sanitize_hex_color( $value ) . ';}';
					break;
				case 'colorlist_margin':
					$css = '.pwf-colorlist-item{ margin-right:' . intval( $value ) . 'px; margin-top:' . intval( $value ) . 'px}';
					$css = '.rtl .pwf-colorlist-item{ margin:' . intval( $value ) . 'px 0 0 ' . intval( $value ) . 'px;}';
					break;
				case 'colorlist_count_font_size':
					$css  = '.pwf-field-item-colorlist .pwf-product-counts,';
					$css .= '.pwf-field-item-colorlist.pwf-rounded .pwf-product-counts{ font-size:' . absint( $value ) . 'px;}';
					break;
				case 'colorlist_count_font_weight':
					$css = '.pwf-field-item-colorlist .pwf-product-counts{ font-weight:' . absint( $value ) . ';}';
					break;
				case 'colorlist_count_text_color':
					$css = '.pwf-field-item-colorlist .pwf-product-counts{ color:' . sanitize_hex_color( $value ) . ';}';
					break;
				case 'colorlist_count_bg_color':
					// converted value = convertHex( value, 6 );
					$css = '.pwf-field-item-colorlist .pwf-product-counts{ background-color:' . sanitize_hex_color( $value ) . ';}';
					break;
				case 'slider_line_height':
					$css = '.pwf-field-item .noUi-horizontal{ height:' . absint( $value ) . 'px;}';
					break;
				case 'slider_handle_width':
					$css = '.pwf-field-item .noUi-horizontal .noUi-handle{ width:' . absint( $value ) . 'px;}';
					break;
				case 'slider_handle_height':
					$css = '.pwf-field-item .noUi-horizontal .noUi-handle{ height:' . absint( $value ) . 'px;}';
					break;
				case 'slider_handle_top':
					$css = '.pwf-field-item .noUi-handle{ top:' . intval( $value ) . 'px;}';
					break;
				case 'slider_handle_border_width':
					$css = '.pwf-field-item .noUi-handle{ border-width:' . absint( $value ) . 'px;}';
					break;
				case 'slider_handle_border_radius':
					$css = '.pwf-field-item .noUi-handle{ border-radius:' . absint( $value ) . '%;}';
					break;
				case 'slider_handle_bg_color':
					$css  = '.pwf-field-item .noUi-connect, .pwf-field-item .noUi-origin,';
					$css .= '.pwf-field-item .noUi-handle{ background-color:' . sanitize_hex_color( $value ) . ';}';
					break;
				case 'slider_handle_border_color':
					$css = '.pwf-field-item .noUi-handle{ border-color:' . sanitize_hex_color( $value ) . ';}';
					break;
				case 'slider_label_color':
					$css = '.pwf-range-slider-labels{ color:' . sanitize_hex_color( $value ) . ';}';
					break;
				case 'search_icon_color':
					$css  = '.pwf-search-icon{ color:' . sanitize_hex_color( $value ) . ';}';
					$css .= '.pwf-search-icon::before{background-color:' . sanitize_hex_color( $value ) . '}';
					break;
				case 'select_font_size':
					$css  = self::get_select_selectors() . '{ font-size:' . absint( $value ) . 'px;}';
					$css .= '.pwf-field-item-dropdownlist .pwf-select::after{ font-size:' . absint( $value ) . 'px;}';
					break;
				case 'select_font_weight':
					$css  = self::get_select_selectors() . '{ font-weight:' . absint( $value ) . ';}';
					$css .= '.pwf-field-item-dropdownlist .pwf-select::after{ font-weight:' . absint( $value ) . ';}';
					break;
				case 'select_height':
					$selc  = '#sidebar .pwf-field-item-dropdownlist select,';
					$selc .= '.woocommerce-page .sidebar .pwf-field-item-dropdownlist select,';
					$selc .= '.pwf-field-item-dropdownlist select';
					$css   = $selc . '{ line-height:' . absint( $value ) . 'px; height:' . absint( $value ) . 'px;}';
					$css  .= '.pwf-field-item-dropdownlist .select2-container .select2-selection--multiple{ min-height:' . absint( $value ) . 'px;}';
					break;
				case 'select_color':
					$selc  = '#sidebar .pwf-field-item-dropdownlist select,';
					$selc .= '.pwf-field-item-dropdownlist .select2-container--default .select2-selection--single,';
					$selc .= '.pwf-field-item-dropdownlist .select2-container--default .select2-selection--single .select2-selection__rendered,';
					$selc .= '.pwf-field-item-dropdownlist select, .pwf-field-item-dropdownlist .pwf-select::after,';
					$selc .= '.pwf-field-item-dropdownlist .select2-container--default .select2-selection--multiple li,';
					$selc .= '#sidebar .pwf-field-item-dropdownlist .select2-container--default .select2-selection--multiple li';

					$css  = $selc . '{ color:' . sanitize_hex_color( $value ) . ';}';
					$css .= '.pwf-field-item-dropdownlist .pwf-select::after{ color:' . sanitize_hex_color( $value ) . ';}';
					break;
				case 'select_border_color':
					$selc  = '#sidebar .pwf-field-item-dropdownlist select,';
					$selc .= '.pwf-field-item-dropdownlist .select2-container--default .select2-selection--single,';
					$selc .= '.pwf-field-item-dropdownlist .select2-container--default .select2-selection--multiple,';
					$selc .= '.pwf-field-item-dropdownlist select, .select2-container--open .pwf-customize-select2';
					$css   = $selc . '{ border-color:' . sanitize_hex_color( $value ) . ';}';
					break;
				case 'input_font_size':
					$css = self::get_input_selectors() . '{ font-size:' . absint( $value ) . 'px;}';
					break;
				case 'input_height':
					$css = self::get_input_selectors() . '{ line-height:' . absint( $value ) . 'px; height:' . absint( $value ) . ';}';
					break;
				case 'input_border_radius':
					$css = self::get_input_selectors() . '{ border-radius:' . absint( $value ) . 'px;}';
					break;
				case 'input_text_color':
					$css = self::get_input_selectors() . '{ color:' . sanitize_hex_color( $value ) . ';}';
					break;
				case 'input_border_color':
					$css = self::get_input_selectors() . '{ border-color:' . sanitize_hex_color( $value ) . ';}';
					break;
				case 'group_items_margin_bottom':
					$css = '.pwf-item-label{ margin-bottom:' . intval( $value ) . 'px;}';
					break;
				case 'group_items_font_size':
					$css = '.pwf-item-label .pwf-title-container .text-title, .pwf-item-label .pwf-toggle::before { font-size:' . absint( $value ) . 'px;}';
					break;
				case 'group_items_line_height':
					$css = '.pwf-item-label .pwf-title-container .text-title,.pwf-item-label .pwf-toggle{ line-height:' . absint( $value ) . 'px;}';
					break;
				case 'group_items_font_weight':
					$css = '.pwf-item-label .pwf-title-container .text-title, .pwf-item-label .pwf-toggle{ font-weight:' . absint( $value ) . ';}';
					break;
				case 'group_items_text_color':
					$css = '.pwf-item-label .pwf-title-container .text-title,.pwf-item-label .pwf-toggle{ color:' . sanitize_hex_color( $value ) . ';}';
					break;
				case 'group_items_text_hover_color':
					$css = '.pwf-item-label.pwf-ui-state-hover > .pwf-title-container .text-title { color:' . sanitize_hex_color( $value ) . ';}';
					break;
				case 'group_items_count_font_size':
					$css = '.pwf-product-counts{ font-size:' . $value . 'px;}';
					break;
				case 'group_items_count_font_weight':
					$css = '.pwf-product-counts{ font-weight:' . $value . ';}';
					break;
				case 'group_items_count_text_color':
					$css = '.pwf-product-counts{ color:' . sanitize_hex_color( $value ) . ';}';
					break;
				case 'checkbox_size':
					$css = self::checkbox_selectors() . '{ height:' . absint( $value ) . 'px; width:' . absint( $value ) . 'px;}';
					break;
				case 'checkbox_border_width':
					$css = self::checkbox_selectors() . '{ border-width:' . absint( $value ) . 'px;}';
					break;
				case 'checkbox_border_radius':
					$css = self::checkbox_selectors() . '{ border-radius:' . absint( $value ) . 'px;}';
					break;
				case 'checkbox_bg_color':
					$css = self::checkbox_selectors() . '{ background-color:' . sanitize_hex_color( $value ) . ';}';
					break;
				case 'checkbox_bg_hover_color':
					$css = self::get_checkbox_hover_selectors() . '{ background-color:' . sanitize_hex_color( $value ) . ';}';
					break;
				case 'checkbox_border_color':
					$css = self::checkbox_selectors() . '{ border-color:' . sanitize_hex_color( $value ) . ';}';
					break;
				case 'checkbox_border_hover_color':
					$css = self::get_checkbox_hover_selectors() . '{ border-color:' . sanitize_hex_color( $value ) . ';}';
					break;
				case 'checkbox_mark_color':
					$css = self::get_mark_selectors() . '{ color:' . sanitize_hex_color( $value ) . '; border-color:' . sanitize_hex_color( $value ) . ';}';
					break;
				case 'checkbox_mark_width':
					$css = self::get_mark_selectors() . '{ width:' . absint( $value ) . 'px;}';
					break;
				case 'checkbox_mark_height':
					$css = self::get_mark_selectors() . '{ height:' . absint( $value ) . 'px;}';
					break;
				case 'checkbox_mark_top_position':
					$css = self::get_mark_selectors() . '{ top:' . intval( $value ) . 'px;}';
					break;
				case 'checkbox_mark_left_position':
					$css = self::get_mark_selectors() . '{ left:' . intval( $value ) . 'px;}';
					break;
				case 'radio_size':
					$css = self::get_radio_selectors() . '{ width:' . absint( $value ) . 'px; height:' . absint( $value ) . 'px;}';
					break;
				case 'radio_border_width':
					$css = self::get_radio_selectors() . '{ border-width:' . absint( $value ) . 'px;}';
					break;
				case 'radio_border_radius':
					$css = self::get_radio_selectors() . '{ border-radius:' . absint( $value ) . '%;}';
					break;
				case 'radio_bg_color':
					$css = self::get_radio_selectors() . '{  background-color:' . sanitize_hex_color( $value ) . ';}';
					break;
				case 'radio_bg_hover_color':
					$css = self::get_radio_hover_selectors() . '{ background-color:' . sanitize_hex_color( $value ) . ';}';
					break;
				case 'radio_border_color':
					$css = self::get_radio_selectors() . '{ border-color:' . sanitize_hex_color( $value ) . ';}';
					break;
				case 'radio_border_hover_color':
					$css = self::get_radio_hover_selectors() . '{ border-color:' . sanitize_hex_color( $value ) . ';}';
					break;
				case 'radio_mark_color':
					$css = self::get_radio_mark_selectors() . '{ background-color:' . sanitize_hex_color( $value ) . ';}';
					break;
				case 'radio_mark_width':
					$css = self::get_radio_mark_selectors() . '{ width:' . absint( $value ) . 'px;}';
					break;
				case 'radio_mark_height':
					$css = self::get_radio_mark_selectors() . '{ height:' . absint( $value ) . 'px;}';
					break;
				case 'radio_mark_top_position':
					$css = self::get_radio_mark_selectors() . '{ top:' . intval( $value ) . 'px;}';
					break;
				case 'radio_mark_left_position':
					$css = self::get_radio_mark_selectors() . '{ left:' . intval( $value ) . 'px;}';
					break;
			}

			return $css;
		}

		// boxlistLabelSelector
		protected static function get_boxlist_lable_selector() {
			return '.pwf-field-item-boxlist .pwf-item-label .pwf-title-container .text-title';
		}

		// selectSelectors
		protected static function get_select_selectors() {
			$selectors  = '#sidebar .pwf-field-item-dropdownlist select,';
			$selectors .= '.pwf-field-item-dropdownlist .select2-container--default .select2-selection--single,';
			$selectors .= '.woocommerce-page .sidebar .pwf-field-item-dropdownlist select,';
			$selectors .= '.pwf-field-item-dropdownlist select,';
			$selectors .= '.select2-container--default .select2-selection--multiple li,';
			$selectors .= '.select2-container--default .select2-selection--multiple .select2-selection__choice__remove';
			return $selectors;
		}

		// inputSelectors
		protected static function get_input_selectors() {
			$selectors  = '.pwf-price-slider-min-max-inputs input,';
			$selectors .= '.pwf-date-field input[type="text"],.woocommerce .pwf-date-field input[type="text"],';
			$selectors .= '.pwf-price-slider-min-max-inputs input[type="number"],.pwf-field-item-search input[type="text"],';
			$selectors .= '.woocommerce .pwf-field-item-search input[type="text"],';
			$selectors .= '.woocommerce-page .pwf-field-item-search  input[type="text"]';

			return $selectors;
		}

		// checkboxSelector
		protected static function checkbox_selectors() {
			$selectors = '.pwf-checkbox-label .pwf-input-container, .pwf-rating-checkbox-type .pwf-input-container';
			return $selectors;

		}

		// checkboxHoverSelectors
		protected static function get_checkbox_hover_selectors() {
			$selectors  = '.pwf-item-label.pwf-ui-state-hover > .pwf-input-container,';
			$selectors .= '.pwf-checkboxlist-item.checked > .pwf-item-inner > .pwf-item-label > .pwf-input-container,';
			$selectors .= '.pwf-rating-checkbox-type.pwf-ui-state-hover > .pwf-input-container,';
			$selectors .= '.pwf-rating-checkbox-type.checked > .pwf-input-container';

			return $selectors;
		}

		// markSelectors
		protected static function get_mark_selectors() {
			$selectors  = '.pwf-checkboxlist-item.checked > .pwf-item-inner > .pwf-item-label .pwf-input-container::after,';
			$selectors .= '.pwf-checkboxlist-item > .pwf-item-inner > .pwf-item-label.pwf-ui-state-hover .pwf-input-container::after,';
			$selectors .= '.pwf-rating-checkbox-type .pwf-star-rating-item.pwf-ui-state-hover .pwf-input-container::after,';
			$selectors .= '.pwf-rating-checkbox-type .pwf-star-rating-item.checked .pwf-input-container::after';

			return $selectors;

		}

		// radioSelector
		protected static function get_radio_selectors() {
			$selectors = '.pwf-radiolist-label .pwf-input-container, .pwf-rating-radio-type .pwf-input-container';
			return $selectors;
		}

		//radioHoverSelectors
		protected static function get_radio_hover_selectors() {
			$selectors  = '.pwf-radiolist-label.pwf-ui-state-hover > .pwf-input-container,';
			$selectors .= '.pwf-radiolist-label.checked > .pwf-input-container,';
			$selectors .= '.pwf-rating-radio-type .pwf-star-rating-item.pwf-ui-state-hover > .pwf-input-container,';
			$selectors .= '.pwf-rating-radio-type .pwf-star-rating-item.checked > .pwf-input-container';

			return $selectors;
		}

		// radioMarkSelectors
		protected static function get_radio_mark_selectors() {
			$selectors  = '.pwf-radiolist-label.checked > .pwf-input-container::after,';
			$selectors .= '.pwf-radiolist-label.pwf-ui-state-hover > .pwf-input-container::after,';
			$selectors .= '.pwf-star-rating-item.pwf-ui-state-hover > .pwf-input-container::after,';
			$selectors .= '.pwf-star-rating-item.checked > .pwf-input-container::after';

			return $selectors;
		}
	}
}
