<?php

defined( 'ABSPATH' ) || exit;

if ( ! class_exists( 'Pwf_Hook_Wp_Query' ) ) {

	class Pwf_Hook_Wp_Query {

		/**
		* The unique instance of the plugin.
		*
		* @var Pwf_Hook_Wp_Query
		*/
		private static $instance;

		/**
		* The unique instance of the Pwf_Parse_Query_Vars.
		*
		* @var Pwf_Parse_Query_Vars
		*/
		private static $query_vars = null;

		private static $filter_id;
		private static $query_type;
		private static $filter_items;
		private static $filter_settings;
		private static $global_args;
		private static $filter_post_type;

		/**
		 * check if analtic add before
		 * On main query analytic can add more times
		 * This variable prevent form add twics
		 */
		private static $is_analytic_add = false;

		private static $page_number;

		/**
		 * @since 1.0.0, 1.0.6, 1.5.4, 1.6.6
		 */
		private function __construct() {
			add_action( 'pre_get_posts', array( $this, 'pre_get_posts_query' ), 20, 1 );
		}

		/**
		 * Gets an instance of our plugin.
		 *
		 * @return Pwf_Hook_Wp_Query
		 */
		public static function get_instance() {
			if ( null === self::$instance ) {
				self::$instance = new self();
			}

			return self::$instance;
		}

		/**
		 * Convert terms save in options to current langauage
		 * Useuful when make compare against current term is translated
		 *
		 * @param array $terms
		 * @param string $type archive or page
		 *
		 * @since 1.5.7, 1.6.6
		 */
		protected static function convert_terms_to_wpml( array $terms, $type ) {
			$results = array();

			if ( 'archive' === $type ) {
				foreach ( $terms as $key => $filter_id ) {
					if ( 'shop_archive' === $key ) {
						$results[ $key ] = $filter_id;
					} else {
						$split     = explode( '__', $key );
						$tax_name  = $split[0];
						$tax_value = $split[1];
						if ( 'all' === $tax_value ) {
							$results[ $key ] = $filter_id;
						} else {
							$tax_value = Pwf_Wpml::get_translated_term_id( absint( $tax_value ), $tax_name );

							$results[ $tax_name . '__' . $tax_value ] = $filter_id;
						}
					}
				}
			} else {
				foreach ( $terms as $page_id => $filter_id ) {
					$page_id = Pwf_Wpml::get_translated_term_id( absint( $page_id ), 'page' );

					$results[ $page_id ] = $filter_id;
				}
			}

			return $results;
		}

		/**
		 * Checking any filter post id integrated with current displaying page
		 * Extract filter post id from saved options
		 *
		 * @param array $args
		 *       $args = array(
		 *         'type'      => '', avaliable values archive | tax | page
		 *         'post_type' => '',
		 *         'tax_name'  => '',
		 *         'tax_id'    => '',
		 *         'page_id'   => '',
		 *       );
		 * @since 1.6.6
		 *
		 * @reuturn int|empty $filter_id
		 */
		protected static function extract_filter_id_from_options( $args ) {
			$filter_id = '';

			if ( 'archive' === $args['page_type'] || 'taxonomy' === $args['page_type'] ) {
				$filter_ids = get_option( 'pwf_woo_main_query_filters', '' );
				if ( ! empty( $filter_ids ) && is_array( $filter_ids ) ) {
					$filter_ids = self::convert_terms_to_wpml( $filter_ids, 'archive' );
					$search_in  = array_keys( $filter_ids );
					/**
					 * This option require to update and make it product_archive
					 */
					if ( 'archive' === $args['page_type'] ) {
						if ( is_array( $args['post_type'] ) && in_array( 'product', $args['post_type'], true ) ) {
							$search_for = 'shop_archive';
						} elseif ( 'product' === $args['post_type'] ) {
							$search_for = 'shop_archive';
						} else {
							$search_for = $args['post_type'] . '_archive';
						}

						if ( in_array( $search_for, $search_in, true ) ) {
							$filter_id = $filter_ids[ $search_for ];
						}
					} else {
						$search_for = $args['taxonomy_name'] . '__' . $args['taxonomy_id'];
						if ( in_array( $search_for, $search_in, true ) ) {
							$filter_id = $filter_ids[ $search_for ];
						} else {
							/**
							 * Checking current taxonomy has ciutom filter ID
							 */
							$search_for = $args['taxonomy_name'] . '__all';
							if ( in_array( $search_for, $search_in, true ) ) {
								$filter_id = $filter_ids[ $search_for ];
							}

							if ( empty( $filter_id ) ) {
								// When saved custom taxonomy save it with post type
								// to by post_tye_tax_name_all or post_tye_tax_name_tax_id
								/**
								 * this code require to change
								 * This code require post type name
								 */
								$filter_id = $filter_ids['shop_archive'];
							}
						}
					}
				}
			} elseif ( 'page' === $args['page_type'] ) {
				$filter_ids = get_option( 'pwf_woo_custom_query_filters', '' );
				if ( ! empty( $filter_ids ) && is_array( $filter_ids ) ) {
					$filter_ids = self::convert_terms_to_wpml( $filter_ids, 'page' );
					$search_in  = array_map( 'absint', array_keys( $filter_ids ) );
					if ( in_array( absint( $args['page_id'] ), $search_in, true ) ) {
						$filter_id = $filter_ids[ $args['page_id'] ];
					}
				}
			}

			return $filter_id;
		}

		/**
		 * Dectecting is there any filter integrate with the current page
		 * This maybe post type archive or pages
		 *
		 * @param object $q WP_Query
		 *
		 * @since 1.6.5
		 *
		 * @return int|empty $filter_id
		 */
		protected function get_filter_id( $q ) {
			$filter_id = '';

			$args = array(
				'page_type'     => '',
				'post_type'     => '', // check if we can delete this
				'taxonomy_name' => '',
				'taxonomy_id'   => '',
				'page_id'       => '',
				'is_archive'    => 'false',
			);

			if ( $q->is_main_query() ) {
				if ( $q->is_archive() ) {
					if ( $q->is_post_type_archive() ) {
						if ( ! empty( $q->query_vars['post_type'] ) ) {
							$args['page_type'] = 'archive';
							$args['post_type'] = $q->query_vars['post_type'];
							if ( ( is_array( $args['post_type'] ) && in_array( 'product', $args['post_type'], true ) ) || 'product' === $args['post_type'] ) {
								$args['page_id'] = absint( get_option( 'woocommerce_shop_page_id' ) );
							}
							/**
							 * can add filter to get page id for other post type
							 * for blog get it from settings
							 */
						}
					} elseif ( $q->is_tax() ) {
						$query_obj = $q->get_queried_object();

						$args['page_type']     = 'taxonomy';
						$args['taxonomy_id']   = $query_obj->term_id;
						$args['taxonomy_name'] = $query_obj->taxonomy;
					}

					if ( ! empty( $args['page_type'] ) ) {
						$args['is_archive'] = 'true';
					}
				} elseif ( $q->is_page() ) {
					$query_obj = $q->get_queried_object();
					if ( isset( $query_obj->ID ) ) {
						$args['page_type'] = 'page';
						$args['page_id']   = $query_obj->ID;
					}
				}
			}

			if ( ! empty( $args['page_type'] ) ) {
				$filter_id = self::extract_filter_id_from_options( $args );
			}

			if ( empty( $filter_id ) ) {
				/**
				 * check divi shop builder used shortcode and doesn't hook main query
				 */
				if ( class_exists( 'AGS_divi_wc' ) ) {
					if ( is_shop() ) {
						$args['page_type'] = 'page';
						$args['page_id']   = absint( get_option( 'woocommerce_shop_page_id' ) );
						$filter_id         = self::extract_filter_id_from_options( $args );
						/**
						 * Because Divi builder useing the default woocommerce shortcode
						 * Require to delete transient genereate by Divi
						 */
						Pwf_Clear_Transients::delete_transients( '_transient_timeout_wc_product_loop_' );
					}
				}
			}

			if ( ! empty( $filter_id ) ) {
				self::$global_args = $args;
			}

			return $filter_id;
		}

		/**
		 * Define all varaiables that are using the filter
		 *
		 * @param int $filter_id
		 *
		 * @since 1.6.6
		 */
		protected function set_filter_variables( $filter_id ) {
			$filter_id = Pwf_Filter_Manager::get_filter_id( $filter_id );
			$filter    = Pwf_Filter_Manager::get_filter_settings_and_items( $filter_id );

			if ( ! empty( $filter ) ) {
				self::$filter_id       = $filter_id;
				self::$filter_items    = $filter['items'];
				self::$filter_settings = $filter['setting'];
				self::$query_type      = $filter['setting']['filter_query_type'];
				// Require to update get it from settings
				self::$filter_post_type = 'product';
			}
		}

		/**
		 * Set plugin global variables after integrate with query hook
		 *
		 */
		protected function set_global_variables() {
			$args = array(
				'filter_id'     => self::$filter_id,
				'post_type'     => self::$filter_post_type,
				'query_vars'    => self::$query_vars,
				'is_archive'    => self::$global_args['is_archive'],
				'page_type'     => self::$global_args['page_type'],
				'taxonomy_name' => self::$global_args['taxonomy_name'],
				'taxonomy_id'   => self::$global_args['taxonomy_id'],
				'page_id'       => self::$global_args['page_id'],
			);

			Pwf_Filter_Manager::set_pwf_global_variables( $args );
		}

		/**
		 * check shortcode types and return its attributes
		 * @since 1.5.4
		 *
		 * @return array shortcode $atts
		 */
		protected static function get_shortcode_atts() {
			$atts    = array();
			$page_id = self::$global_args['page_id'];

			switch ( self::$filter_settings['shortcode_type'] ) {
				case 'default_woocommerce':
					$atts = Pwf_Woo_Utilities::extract_shortcode_attrs( self::$filter_settings['shortcode_string'] );
					break;
				case 'elementor_pro':
					$atts = Pwf_Elementor_Pro::get_widget_date( $page_id );
					if ( ! empty( $atts ) ) {
						$atts['limit'] = $atts['rows'] * $atts['columns'];
					}
					break;
				case 'powerpack_for_elementor':
					$atts = Pwf_Powerpack_Elements::get_widget_date( $page_id );
					if ( ! empty( $atts ) ) {
						$atts['limit'] = $atts['products_per_page'];
					}
					break;
			}

			return $atts;
		}

		/**
		 * Check if that the wp_query requires to hook.
		 * The page can contain many querys to display products
		 * On the forntend like widgets, shortcode, ...
		 * Our plugin check only by limit
		 *
		 * @param object $q wp_query
		 *
		 * @since 1.6.6
		 */
		protected static function is_that_exact_query_requires( $q ) {
			$current_post_type = $q->get( 'post_type' );

			if ( empty( $current_post_type ) ) {
				return false;
			} else {
				if ( ! is_array( $current_post_type ) ) {
					$current_post_type = array( $current_post_type );
				}
			}

			if ( ! in_array( self::$filter_post_type, $current_post_type, true ) ) {
				return false;
			}

			$result = false;
			$atts   = self::get_shortcode_atts();
			if ( ! empty( $atts ) && is_array( $atts ) ) {
				$limit    = $atts['limit'] ?? -1; // -1 mean display all products for shortcode
				$per_page = $q->get( 'posts_per_page' );
				if ( ! empty( $limit ) && ! empty( $per_page ) ) {
					if ( absint( $limit ) === absint( $per_page ) ) {
						$result = true;
					}
				}
			}

			/**
			 * Develop can do another check.
			 * To be sure this is the wp_query requires to hook
			 *
			 * @param bool $result
			 * @param int $filter_id
			 * @param object wp_query
			 * @param array shortcode attributes
			 */
			$result = apply_filters( 'pwf_check_is_that_taregt_custom_query', $result, self::$filter_id, $q, $atts );

			return $result;
		}

		/**
		 * @since 1.6.6
		 */
		protected static function check_current_page_number() {
			global $wp;

			$current_url = home_url( add_query_arg( array(), $wp->request ) );

			// get the position where '/page.. ' text start.
			$pos = strpos( $current_url, '/page' );

			// remove string from the specific postion
			$url = ( $pos ) ? substr( $current_url, $pos ) : $current_url;

			$page_num = preg_replace( '/[^0-9]/', '', $url );

			if ( $page_num ) {
				self::$page_number = absint( $page_num );
			}
		}

		/**
		 * Hook any WP Query maybe main or custom query.
		 * Checking if any filter post require to hook this query.
		 *
		 * Useful if clients go directly or using option no ajax
		 *
		 * @param object $q WP_Query
		 *
		 * @since 1.6.6
		 */
		public function pre_get_posts_query( $q ) {
			$filter_id = $this->get_filter_id( $q );

			if ( empty( $filter_id ) ) {
				return;
			}

			$this->set_filter_variables( $filter_id );

			if ( null === self::$filter_items ) {
				return;
			}

			$this->set_global_variables();

			// This hook doesn't require any more
			remove_action( 'pre_get_posts', array( $this, 'pre_get_posts_query' ), 20, 1 );

			if ( 'main_query' === self::$query_type ) {
				$this->prepare_target_query( $q );
			} else {
				add_action( 'pre_get_posts', array( $this, 'prepare_custom_query' ), 10, 1 );
			}
		}

		/**
		 * Excute functions if this custom query
		 * @since 1.6.6
		 */
		public function prepare_custom_query( $q ) {
			if ( 'custom_query' === self::$query_type && self::is_that_exact_query_requires( $q ) ) {
				self::check_current_page_number();
				$this->prepare_target_query( $q );
			}
		}

		/**
		 * This use to hook main query and custom query
		 *
		 * @param $q wp_query
		 *
		 * @since 1.5.4, 1.6.6
		 *
		 */
		public function prepare_target_query( $q ) {
			/**
			 * check if selected options exists
			 * Fixed the issue when the filter displays before WP_Query specially when filter set to custom_query
			 */
			if ( ! empty( $GLOBALS['pwf_main_query']['query_vars'] ) ) {
				self::$query_vars = $GLOBALS['pwf_main_query']['query_vars'];
			} else {
				$selected_options = Pwf_Filter_Manager::get_user_selected_options( self::$filter_id, self::$filter_items );
				self::$query_vars = new Pwf_Parse_Query_Vars( self::$filter_id, $selected_options );
			}

			/**
			 * Useful with custom query if the filter items displays before WP_Query that displays posts/products
			 */
			$args = array(
				'filter_integrated' => 'yes',
			);
			if ( empty( $GLOBALS['pwf_main_query']['query_vars'] ) ) {
				$args['query_vars'] = self::$query_vars;
			}
			Pwf_Filter_Manager::set_pwf_global_variables( $args );

			$orderby    = self::$query_vars->get_products_orderby();
			$tax_query  = self::$query_vars->get_tax_query_filter_items();
			$meta_query = self::$query_vars->get_meta_query();
			$authors_id = self::$query_vars->get_authors_id();
			$date_query = self::$query_vars->get_date_query();

			if ( ! empty( self::$query_vars->get_search_query() ) ) {
				// Get[s] check if woocommerce add these code before in wc_query
				if ( 'custom_query' === self::$query_type || ! isset( $_GET['s'] ) ) {
					$q->set( 's', self::$query_vars->get_search_query() );
					$q->set( 'is_search', true );
				}
				if ( 'only_title' === self::$query_vars->get_search_inside() ) {
					add_filter( 'posts_search', array( $this, 'search_by_title_only' ), 200, 1 );
				}
			}

			if ( ! empty( $tax_query ) ) {
				if ( ! empty( $q->get( 'tax_query' ) ) ) {
					$tax_query = array_merge( $q->get( 'tax_query' ), $tax_query );
				}
				$q->set( 'tax_query', $tax_query );
			}

			if ( ! empty( $meta_query ) ) {
				$meta_query = array_merge( $q->get( 'meta_query' ), $meta_query );
				$q->set( 'meta_query', $meta_query );
			}

			if ( ! empty( $authors_id ) ) {
				$authors_id = array_merge( $q->get( 'author__in' ), $authors_id );
				$q->set( 'author__in', $authors_id );
			}

			if ( ! empty( $date_query ) ) {
				$q->set( 'date_query', $date_query );
			}

			if ( null !== self::$page_number ) {
				$q->set( 'paged', self::$page_number );
			}

			if ( 'product' === self::$filter_post_type ) {
				$hook_woo_query = new Pwf_Hook_Woocommerce_Query( self::$query_vars, $q, self::$query_type );
			} elseif ( ! empty( $orderby ) ) {
				$orderby = is_array( $orderby ) ? implode( '', $orderby ) : $orderby;
				$q->set( 'orderby', $orderby );
			}

			add_filter( 'the_posts', array( $this, 'remove_product_query_filters' ), 20, 1 );
		}

		public function remove_product_query_filters( $posts ) {
			self::add_anlaytic_data();

			return $posts;
		}

		public function search_by_title_only( $search ) {
			return Pwf_Db_Utilities::get_search_where_sql( self::$query_vars->get_search_query(), self::$filter_id, self::$query_vars, 'only_title' );
		}

		protected static function add_anlaytic_data() {
			global $wp_query;

			if ( self::$is_analytic_add ) {
				return;
			}

			$selected_items = self::$query_vars->selected_items();
			if ( empty( $selected_items ) ) {
				return;
			}

			$anlaytic = get_option( 'pwf_shop_analytics', 'disable' );
			if ( 'disable' === $anlaytic ) {
				return;
			}

			$orderby = self::$query_vars->get_products_orderby();
			if ( ! empty( $orderby ) ) {
				$orderby = is_array( $orderby ) ? implode( ',', $orderby ) : $orderby;
			} elseif ( isset( $_GET['orderby'] ) ) {
				$orderby = esc_attr( $_GET['orderby'] );
			}

			if ( ! empty( $orderby ) ) {
				$selected_items['orderby'] = array(
					'values' => array( $orderby ),
					'type'   => 'orderby',
				);
			}

			$filter_data = array(
				'filter_post_id' => self::$filter_id,
				'products_count' => $wp_query->found_posts,
				'from'           => 1,
				'query_string'   => self::$query_vars->get_query_string(),
			);

			$analytic_data = array(
				'filter_data'     => $filter_data,
				'selected_values' => $selected_items,
			);

			self::$is_analytic_add = true;

			$analytic = new Pwf_Analytic_Query( $analytic_data );
		}
	}

	$pwf_hook_wp_query = Pwf_Hook_Wp_Query::get_instance();
}
