<?php

defined( 'ABSPATH' ) || exit;

if ( ! class_exists( 'Pwf_Update' ) ) {

	/**
	 * @ since 1.5.4
	 */
	class Pwf_Update {

		public function __construct( array $args ) {
			foreach ( $args as $arg ) {
				switch ( $arg ) {
					case 'update_filter_post':
						self::update_filter_post();
						break;
					case 'add_pretty_urls':
						self::add_pretty_urls();
						break;
				}
			}
			add_action( 'admin_notices', array( $this, 'admin_notice' ) );
		}

		protected static function get_query_args() {
			$args = array(
				'post_type'           => 'pwf_woofilter',
				'post_status'         => 'any',
				'ignore_sticky_posts' => -1,
				'posts_per_page'      => -1,
			);

			return $args;
		}

		protected static function update_filter_post() {
			$shop_filter_id = get_option( 'pwf_shop_filter_id', '' );
			$filter_posts   = get_posts( self::get_query_args() );

			if ( $filter_posts ) {
				foreach ( $filter_posts as $post ) {
					$post_id = absint( $post->ID );
					$meta    = get_post_meta( absint( $post_id ), '_pwf_woo_post_filter', true );
					if ( ! empty( $meta ) ) {
						$settings = self::update_filter_settings( $meta['setting'] );
						if ( absint( $shop_filter_id ) === $post_id ) {
							$settings['filter_query_type'] = 'main_query';

							$save_option = array(
								'shop_archive' => $post_id,
							);
							update_option( 'pwf_woo_main_query_filters', $save_option, 'no' );
							delete_option( 'pwf_shop_filter_id' );
						}

						$items = self::update_filter_items( $meta['items'] );

						$meta_data = array(
							'setting' => $settings,
							'items'   => $items,
						);
						update_post_meta( $post_id, '_pwf_woo_post_filter', $meta_data );
					}
				}
			}
		}

		protected static function update_filter_settings( $settings ) {
			$settings['title_toggle_icon']    = $settings['title_toggle_icon'] ?? 'arrow';
			$settings['term_toggle_icon']     = $settings['term_toggle_icon'] ?? 'arrow';
			$settings['filter_query_archive'] = $settings['filter_query_archive'] ?? '';
			$settings['filter_query_pages']   = $settings['filter_query_pages'] ?? '';

			if ( isset( $settings['is_shortcode'] ) && 'on' === $settings['is_shortcode'] ) {
				$settings['filter_query_type'] = 'custom_query';
			} else {
				$settings['filter_query_type'] = '';
			}

			unset( $settings['is_shortcode'] );

			return $settings;
		}

		protected static function update_filter_items( $items ) {
			foreach ( $items as $key => $item ) {
				if ( 'column' !== $item['item_type'] && 'button' !== $item['item_type'] ) {
					if ( ! isset( $item['depends_on'] ) ) {
						$items[ $key ]['depends_on'] = '';
					}
					if ( ! isset( $item['depends_on_operator'] ) ) {
						$items[ $key ]['depends_on_operator'] = 'and';
					}
					if ( ! isset( $item['product_variations'] ) ) {
						if ( in_array( $item['item_type'], array( 'checkboxlist', 'radiolist', 'textlist', 'dropdownlist', 'colorlist', 'boxlist' ), true ) ) {
							$items[ $key ]['product_variations'] = '';
						}
					}
					if ( ! isset( $item['dropdown_style'] ) && 'dropdownlist' === $item['item_type'] ) {
						$items[ $key ]['dropdown_style'] = 'default';
					}
					if ( ! isset( $item['search_inside'] ) && 'search' === $item['item_type'] ) {
						$items[ $key ]['search_inside'] = 'all';
					}
				}
			}

			return $items;
		}

		/**
		 * @since 1.5.7
		 */
		protected static function add_pretty_urls() {
			$filter_posts = get_posts( self::get_query_args() );
			if ( $filter_posts ) {
				foreach ( $filter_posts as $post ) {
					$post_id = absint( $post->ID );
					$meta    = get_post_meta( absint( $post_id ), '_pwf_woo_post_filter', true );
					if ( ! empty( $meta ) ) {
						$meta['setting']['pretty_urls'] = 'off';

						$meta_data = array(
							'setting' => $meta['setting'],
							'items'   => $meta['items'],
						);
						update_post_meta( $post_id, '_pwf_woo_post_filter', $meta_data );
					}
				}

				Pwf_Routes_Manager::regenerates_routes();
			}
		}

		public function admin_notice() {
			echo '<div class="notice notice-warning is-dismissible">';
			echo '<p><strong>PWF Woocommerce Product Filters plugin release a major update <a href="https://docs.mostafaa.net/plugins/pwfwoofilter/docs-page.html#update-to-1.5.4" target="_blank">read more.</strong></p>';
			echo '</div>';
		}
	}
}
