<?php

defined( 'ABSPATH' ) || exit;

if ( ! class_exists( 'Pwf_Woo_Utilities' ) ) {

	/**
	 * Assign all WooCommerce functions at on place
	 *
	 * @since 1.6.6
	 */

	class Pwf_Woo_Utilities {

		public function __construct() {}

		/**
		 * Default Woocommerce shortcode attributes
		 * @see class Pwf_Integrate shortcode, parse_query_vars
		 *
		 * @since 1.5.4
		 *
		 * @return array $atts Default woocommerce shortcode attributes
		 */
		public static function get_woo_shortcode_default_attrs() {
			return array(
				'limit'          => '',
				'columns'        => '',
				'paginate'       => false,
				'skus'           => '',
				'ids'            => '',
				'on_sale'        => false,
				'best_selling'   => false,
				'top_rated'      => false,
				'category'       => '',
				'cat_operator'   => 'IN',
				'tag'            => '',
				'tag_operator'   => 'IN',
				'attribute'      => '',
				'terms'          => '',
				'terms_operator' => 'IN',
				'visibility'     => '',
				'order'          => '',
				'orderby'        => '',
			);
		}

		/**
		 * Extraxt shortcode attributes from string
		 *
		 * @since 1.5.4
		 *
		 * @param string $shortcode shortcode string [product ]
		 *
		 * @return array
		 */
		public static function extract_shortcode_attrs( $shortcode ) {
			$first_char = substr( $shortcode, 0, 1 );
			if ( '[' === $first_char ) {
				$shortcode = substr( $shortcode, 1 );
			}
			$last_char = substr( $shortcode, -1, 1 );
			if ( ']' === $last_char ) {
				$len       = strlen( $shortcode ) - 1;
				$shortcode = substr( $shortcode, 0, $len );
			}

			if ( 'products' !== substr( $shortcode, 0, strlen( 'products' ) ) ) {
				return;
			}

			$shortcode = str_replace( 'products', '', $shortcode );
			$atts      = shortcode_parse_atts( $shortcode );

			return $atts;
		}

		protected static function get_tax_query_out_of_stock() {
			return array(
				'taxonomy'         => 'product_visibility',
				'terms'            => array( 'outofstock' ),
				'field'            => 'slug',
				'operator'         => 'NOT IN',
				'include_children' => true,
			);
		}

		public static function get_product_visibility() {
			$exclude_from_catalog = array(
				'taxonomy'         => 'product_visibility',
				'terms'            => array( 'exclude-from-catalog' ),
				'field'            => 'slug',
				'operator'         => 'NOT IN',
				'include_children' => true,
			);

			$tax_query[] = $exclude_from_catalog;

			/*
			 * usefule when get products using ajax
			 */
			if ( 'yes' === get_option( 'woocommerce_hide_out_of_stock_items' ) ) {
				$tax_query[] = self::get_tax_query_out_of_stock();
			}

			return $tax_query;
		}

	}
}
