<?php
/*------------------------------------------------------------------------------
Plugin Name: PWF WooCommerce Product Filters
Description: WooCommerce Products Filter. Flexible, easy and robust product filters for WooCommerce plugin!
Plugin URI:  https://codecanyon.net/item/pwf-woocommerce-product-filters/28181010
Version:     1.6.8
Author:      Mostafa
Author URI:  https://mostafaa.net/
License:     Codecanyon Split Licence
text domain: pwf-woo-filter
Domain Path: /languages
WC requires at least: 4.3.0
WC tested up to: 6.3.1
------------------------------------------------------------------------------*/

defined( 'ABSPATH' ) || exit; // exit if file is called directly

const PWF_WOO_FILTER_VER        = '1.6.8';
const PWF_WOO_FILTER_DB_VERSION = '1.0.0';

define( 'PWF_WOO_FILTER_URI', plugins_url( '', __FILE__ ) );
define( 'PWF_WOO_FILTER_DIR', plugin_dir_path( __FILE__ ) );
define( 'PWF_WOO_FILTER_DIR_DOMAIN', dirname( plugin_basename( __FILE__ ) ) );


require_once( 'includes/classes/class-pwf-autoloader.php' );
require_once( 'includes/class-pwf-main.php' );
require_once( 'includes/widgets/class-pwf-filter-widget.php' );
require_once( 'includes/render/class-pwf-render-filter.php' );
require_once( 'includes/class-pwf-front-end-ajax.php' );
require_once( 'includes/classes/api/class-pwf-api.php' );

if ( ! is_admin() ) {
	require_once( 'includes/classes/class-pwf-hook-wp-query.php' );


	$enable_pretty_urls = get_option( 'pwf_shop_enable_pretty_links', 'enable' );
	if ( 'enable' === $enable_pretty_urls ) {
		require_once( 'includes/classes/class-pwf-parse-request.php' );
	}
}
if ( is_admin() && ! is_plugin_ajax() ) {
	require_once( 'includes/classes/admin/class-pwf-admin-main.php' );
	require_once( 'includes/classes/admin/class-pwf-clear-transients.php' );
	require_once( 'includes/classes/admin/class-pwf-admin-setting.php' );
}




/**
 * Checking if the URL request comes form frontfend Ajax.
 */
function is_plugin_ajax() {
	$result      = false;
	$post_action = $_POST['action'] ?? '';
	$get_action  = $_GET['action'] ?? '';
	if ( 'get_filter_result' === $post_action || 'get_filter_result' === $get_action ) {
		$result = true;
	}

	return apply_filters( 'is_plugin_ajax', $result );
}
