import intlTelInput from 'intl-tel-input';
import './phone-validation';

var $j = jQuery.noConflict();

var telInputs = wipiMainJsVars.wpiElements.split(', ');
var countrySearchEnabled = wipiMainJsVars.countrySearchEnabled === '1';
var autoSetIpEnabled = wipiMainJsVars.autoSetIp === '1';

(function ($j) {
  for (var i = 0; i < telInputs.length; i++) {

    let telInputEls = document.querySelectorAll(telInputs[i]);

    let options = {
      nationalMode: true,
      utilsScript: wipiMainJsVars.utilsScript,
      containerClass: 'wcipi-container',
      countrySearch: countrySearchEnabled,
      i18n: {
        searchPlaceholder: wipiMainJsVars.searchTermLocalized,
      }
    }

    if (wipiMainJsVars.initialCountry.length > 0) {
      options.initialCountry = wipiMainJsVars.initialCountry;
    } else if (autoSetIpEnabled) {
      options.initialCountry = "auto";

      let requestData = {};
      if (wipiMainJsVars.ipInfoToken.length > 0) {
        requestData = { token: wipiMainJsVars.ipInfoToken };
      }
      options.geoIpLookup = function (success, failure) {
        $j.get("https://ipinfo.io/json", requestData, "jsonp").always(function (resp) {
          let countryCode = (resp && resp.country) ? resp.country : "";
          success(countryCode);
        });
      }
    }

    if (wipiMainJsVars.onlySelectedCountries) {
      options.onlyCountries = JSON.parse(wipiMainJsVars.onlyCountries);
    }

    if (wipiMainJsVars.preferredCountries.length > 0) {
      options.preferredCountries = wipiMainJsVars.preferredCountries;
    }

    telInputEls.forEach((el) => {
      let intTelInputInstance = intlTelInput(el, options);

      // if phone number is prepopulated
      // and no country is selected
      // then reset the phone number to trigger flag selection
      if (el.value.length > 0 && intTelInputInstance.getSelectedCountryData()['iso2'] === undefined) {
        let prePopulatedPhoneValue = el.value;
        intTelInputInstance.setNumber('');
        setTimeout(function () {
          intTelInputInstance.setNumber(prePopulatedPhoneValue);
        }, 600);
      }

      // close on country submenu on container click
      // https://github.com/woocommerce/woocommerce/issues/22720
      intTelInputInstance.flagsContainer.querySelector('.iti__selected-flag').addEventListener('mouseup', function() {
        handleDropdownCloseOnToggle(intTelInputInstance);
        handleDropdownCloseOnBlur(intTelInputInstance);
      });
    });
  }
})($j);

function handleDropdownCloseOnBlur(intTelInputInstance) {
  window.addEventListener('click', function(e) {
    let clickedTarget = e.target;

    if (!intTelInputInstance.countryList.contains(clickedTarget)){
      intTelInputInstance._closeDropdown();
    }
  });
}

function handleDropdownCloseOnToggle(intTelInputInstance) {
  const itiOpen = (intTelInputInstance.countryList.offsetParent !== null);
  setTimeout(function(){
    if (itiOpen) {
      intTelInputInstance._closeDropdown();
    }
  }, 100);
}
