<?php 
if ( ! defined( 'ABSPATH' ) ) exit;   


add_filter('saswp_the_excerpt', 'saswp_filter_paywall_excerpt');

function saswp_filter_paywall_excerpt($excerpt){
    
    global $post;

    if(is_object($post)){

        $force_public = get_post_meta($post->ID, $key='_wc_memberships_force_public', true);
    
        if((!$force_public || $force_public =='no')){
        
            $excerpt = $post->post_content;
            $excerpt = wp_trim_words($excerpt, 55);                 
            
        }

    }
        
    return $excerpt;
    
}

add_filter('saswp_the_content', 'saswp_filter_paywall_content');

function saswp_filter_paywall_content($content){
    
    global $post;
    
    if(is_object($post)){

        $force_public = get_post_meta($post->ID, $key='_wc_memberships_force_public', true);
    
        if((!$force_public || $force_public =='no') && is_plugin_active('woocommerce-memberships/woocommerce-memberships.php')){
                    
            if (!preg_match('/bot|crawl|curl|dataprovider|search|get|spider|find|java|majesticsEO|google|yahoo|teoma|contaxe|yandex|libwww-perl|facebookexternalhit/i', $_SERVER['HTTP_USER_AGENT'])) {
                $content = wp_trim_words($content, 55);        
            }
                                    
        }

    }
                
    return $content;
}

function saswp_woocommerce_membership_paywall($content){
    
        global $post;
        
        $force_public = get_post_meta($post->ID, $key='_wc_memberships_force_public', true);
        
        if((!$force_public || $force_public =='no')){
         
            $content = '<div class="saswp-paywall">'.$content.'</div>';
            
        }
        
        return $content;
    
}

add_filter('wc_memberships_restricted_content_excerpt', 'saswp_woocommerce_membership_paywall',3,10);

function saswp_add_woocommerce_membership_schema($input1){
        
        global $sd_data;
        
        $force_public = get_post_meta(get_the_ID(), '_wc_memberships_force_public', true);
                        
        if((!$force_public || $force_public =='no') && isset($sd_data['saswp-woocommerce-membership']) && $sd_data['saswp-woocommerce-membership'] == 1 && is_plugin_active('woocommerce-memberships/woocommerce-memberships.php')){

            $saswp_paywall = array("isAccessibleForFree"=> "False",
                                             "hasPart"=>array(
                                                        "@type"               => "WebPageElement",
                                                        "isAccessibleForFree" => "False",
                                                        "cssSelector"         => '.saswp-paywall'
                                                      )
                                                  );
            $input1 = array_merge($input1,$saswp_paywall);                                      
        }
    
    return $input1;
}
                                
add_filter('saswp_modify_woocommerce_membership_schema', 'saswp_add_woocommerce_membership_schema');

add_filter('saswp_modify_product_schema_output', 'saswp_woo_product_schema',10,1);

function saswp_woo_product_schema($input){
    
    global $post, $woocommerce;
    
    if (class_exists('WC_Product')) {
                
        $product = wc_get_product($post->ID); 
        $add_info      = array();
        if(is_object($product)){
            
            if($product->get_type() == 'variable'){
            
            $product_id_some = $woocommerce->product_factory->get_product();
            
            $variations  = $product_id_some->get_available_variations();                        
            
            if($variations){
                
               $offers        = array();                
               $k = 0;
               foreach($variations as $val){
                
                    $manage_stock = get_post_meta($val['variation_id'], $key='_manage_stock', true);
                    
                    $availability = 'OutOfStock';
                    
                    if($manage_stock == 'no'){
                        if(isset($val['is_in_stock']) && $val['is_in_stock'] == 1){
                            $availability = 'InStock';
                        }
                    }else{
                        if(isset($val['max_qty']) && $val['max_qty'] > 0){
                            $availability = 'InStock';
                       }
                    }

                   $gtin13 = get_post_meta($val['variation_id'], $key='_barcode', true);                   
 
                   $single_offer = array(
                    '@type'         => 'Offer',
                    'price'         => $val['display_price'],                     
                    'priceCurrency' => get_woocommerce_currency(),
                    'sku'           => $val['sku'],
                    'availability'  => $availability,
                    'gtin13'        =>  $gtin13,
                    'description'   => wp_strip_all_tags(strip_shortcodes($val['variation_description']))                                                                   
                  );

                  $gtin = get_post_meta( $val['variation_id'] , 'woo_feed_gtin_var', true );

                  if($gtin){

                    $single_offer['gtin'] = $gtin;

                  }

                  $mpn = get_post_meta( $val['variation_id'] , 'woo_feed_mpn_var', true );

                  if($mpn){

                    $single_offer['mpn'] = $mpn;
                    
                  }
                  
                   $offers[] = apply_filters('saswp_modify_product_variations_output', $single_offer, $val);
                   
                   if(isset($val['attributes'])){
                       
                       foreach ($val['attributes'] as $key => $val){
                       
                           if($val){
                               
                            $name = ltrim($key,'attribute_');   
                            
                            $add_info[] = array(
                             '@type' => 'PropertyValue',
                             'name'  => $name,
                             'value' => $val       
                            );   
                                                           
                           }
                           
                       }                       
                       
                   }
                    $k++;                  
               }
                              
               if(isset($input['offers'])){
                   $input['offers']['offers'] = $offers;
               }
                                            
            }
            
          }else{

            $input['offers']['priceCurrency'] = get_woocommerce_currency();

          }
          
          $service_object     = new saswp_output_service();
          $publisher          = $service_object->saswp_get_publisher();          

           if(!empty($publisher['publisher'])){
                $input['offers']['seller']         =    $publisher['publisher'];            
           }
        
            $ultimate_reviews = saswp_get_ultimate_reviews($product);
            
            if($ultimate_reviews){
                
                $input['review']          = $ultimate_reviews['review'];
                $input['aggregateRating'] = $ultimate_reviews['rating'];
                
            }

            $brand_names = wp_get_post_terms( $post->ID, 'berocket_brand', array( 'fields' => 'names' ) );

            if(!is_wp_error($brand_names)){
                if(!empty($brand_names)){
                    $input['brand']['name'] = $brand_names;
                }
            }

            $pwb_brands = wp_get_post_terms( $post->ID, 'pwb-brand' );
                       
            if(!is_wp_error($pwb_brands)){

                if(!empty($pwb_brands)){

                    $brand_arr = array();

                    foreach ($pwb_brands as $key => $value) {
                        $brand = array();
                        $brand['@type'] = 'Brand';
                        $brand['name']  = $value->name;
                        $brand['url']   = get_term_link($value);

                        $term_meta = get_term_meta($value->term_id);
                        if(!empty($term_meta['pwb_brand_banner'][0])){
                            $brand['image'] = saswp_get_image_by_id($term_meta['pwb_brand_banner'][0]);
                        }
                        if(!empty($term_meta['pwb_brand_image'][0])){
                            $brand['logo'] = saswp_get_image_by_id($term_meta['pwb_brand_image'][0]);
                        }                                                                        
                        $brand_arr[] = $brand;
                    }                    
                    $input['brand'] = $brand_arr;

                }
            }
                                    
            $yith = get_post_meta($post->ID, $key='yith_wcgpf_product_feed_configuration', true);

            if( isset($yith['brand']) ){
                $input['brand']['name'] = $yith['brand'];
            } 

             $woo_gtin = get_post_meta($post->ID, 'woo_feed_gtin', true);

             if($woo_gtin !=''){                 
                $input['gtin'] = $woo_gtin;                   
             }

             $woo_mpn = get_post_meta($post->ID, 'woo_feed_mpn', true);

             if($woo_mpn !=''){                 
                $input['mpn'] = $woo_mpn;                   
             }
            
            $add_attributes = $product->get_attributes();
            
            if(!empty($add_attributes)){
                
                foreach($add_attributes as $key => $val){

                    $attr     = str_replace('pa_', '', $key);                     
                    $attr_val = $product->get_attribute($key);                    
                    $attr_val = str_replace('pa_', '', $attr_val);

                    switch ( strtolower($attr) ) {

                        case 'color':
                            $input['color'] = $attr_val;
                            break;
                        case 'size':
                            $input['size'] = $attr_val;
                            break; 
                        case 'weight':
                            $input['weight'] = $attr_val;
                            break; 
                        case 'width':
                            $input['width'] = $attr_val;
                            break; 
                        case 'height':
                            $input['height'] = $attr_val;
                            break;    
                        
                        default:
                            $add_info[] = array(
                                '@type' => 'PropertyValue',
                                'name'  => $attr,
                                'value' => $attr_val       
                            );                            
                            break;
                    }
                    
                }
            }

            if($add_info){
                $input['additionalProperty'] = $add_info;
            }
           
        }
                                
    }        
    
    return $input;
    
}

