<?php 
if ( ! defined( 'ABSPATH' ) ) exit;
/**
 * Action to add booking schema markup for woocommerce booking add-on
 * @param type $order
 * @param type $sent_to_admin
 * @param type $plain_text
 * @param type $email
 */
function saswp_woocommerce_email_order_details( $order, $sent_to_admin, $plain_text, $email ) {
    
        global $sd_data;
        
        if(isset($sd_data['saswp-woocommerce-booking']) && $sd_data['saswp-woocommerce-booking'] == 1 && is_plugin_active('woocommerce-bookings/woocommerce-bookings.php')){
                           
         $input = array();
         $offer = array();
         
         $input['@context']                                     = 'http://schema.org';
         $input['@type']                                        =  'Order';
         $input['merchant']['@type']                            =  'Organization';
         $input['merchant']['name']                             =  $order->get_billing_company();
         $input['orderNumber']                                  =  $order->get_order_number();
         $input['orderStatus']                                  =  'Order'.$order->get_status();                  
         $input['priceCurrency']                                =  $order->get_currency();
         $input['price']                                        =  $order->get_total();
         $input['priceSpecification']['@type']                  =  'PriceSpecification';
         $input['priceSpecification']['validFrom']              =  date('Y-m-d\TH:i:s\Z',$order->get_date_modified());
         
         $input['billingAddress']['@type']                      =  'PostalAddress';
         $input['billingAddress']['name']                       =  $order->get_billing_first_name().', '.$order->get_billing_last_name();
         $input['billingAddress']['streetAddress']              =  $order->get_billing_address_1().', '.$order->get_billing_address_2();
         $input['billingAddress']['addressLocality']            =  $order->get_billing_city();
         $input['billingAddress']['addressRegion']              =  $order->get_billing_state();
         $input['billingAddress']['addressCountry']             =  $order->get_billing_country();
         
         if($order->get_items()){
         
             foreach ( $order->get_items() as $item_id => $item ) {
                 
			$product             = $item->get_product();
                        
                        $offer_ar = array();
                        
                        $offer_ar['@type'] = "Offer";
			$offer_ar['itemOffered'] = array(  
				'@type'      => 'Product',
                                'name'       => $item->get_name(),
                                'sku'        => is_object( $product ) ? $product->get_sku() : null,
                                //'image'      => $item->get_image(),
                                //'url'        => is_object( $product ) ? $product->get_product_url() : null,
				
			);
                        
                        $offer_ar['price'] = wc_format_decimal( $order->get_item_total( $item ), 2 );
                        $offer_ar['priceCurrency'] = "Product";
                        
                        $offer_ar['eligibleQuantity']['@type'] = "QuantitativeValue";
                        $offer_ar['eligibleQuantity']['value'] = $item->get_quantity();
                        
                        $offer[] = $offer_ar;
		}
                          
         }
         
         
         if($offer){
         $input['acceptedOffer']                =  $offer;    
         }                                   
         $input['url']                          =  $order->get_view_order_url();
         $input['potentialAction']['@type']     =  'ViewAction';
         $input['potentialAction']['url']       =  $order->get_view_order_url();
                                             
         if(!empty($input)){
             
             echo '<script type="application/ld+json">';
             echo json_encode($input);
             echo '</script>';
             
         }
                  
        }
    
}
add_action( 'woocommerce_email_order_details', 'saswp_woocommerce_email_order_details', 10, 4 );


function saswp_get_ultimate_reviews($product){
    
    $reviews_arr = array();
    $aggregate   = array();
    $response    = array();
    
    if(function_exists('EWD_URP_Display_Reviews')){
		
        $sumofrating = 0;
        $avg_rating  = 1;
				        
        $arg = array(
            'post_type'    => 'urp_review',
            'post_status'  => 'publish',
            'numberposts'  => -1,		
            'meta_query'   => array(
                                        array(
                                        'key'     => 'EWD_URP_Product_Name',
                                        'value'   => $product->get_name(),
                                        'compare' => '=',
                                )
                      ),
        );        
    
        $rv_posts = get_posts($arg);
    
    if($rv_posts){
        
        foreach ($rv_posts as $value){
            
            $reviews_arr[] = array(
                    
                     '@type'         => 'Review',
                     'author'        => get_post_meta($value->ID, $key='EWD_URP_Post_Author', true),
                     'datePublished' => saswp_format_date_time($value->post_date),
                     'description'   => $value->post_content,
                     'reviewRating'  => array(
                                            '@type'	        => 'Rating',
                                            'bestRating'	=> '5',
                                            'ratingValue'	=>  get_post_meta($value->ID, $key='EWD_URP_Overall_Score', true),
                                            'worstRating'	=> '1',
                               )
                                                       
                 );
				 
		$sumofrating += get_post_meta($value->ID, $key='EWD_URP_Overall_Score', true);
                        
            }
        
            if($sumofrating> 0){
              $avg_rating = $sumofrating /  count($rv_posts); 
            }

            $aggregate = array(
                            '@type'       => 'AggregateRating',
                            'reviewCount' => count($rv_posts),
                            'ratingValue' => $avg_rating,                                        
            );
            
	    $response = array('review' => $reviews_arr, 'rating' => $aggregate);
            
        }      
                
    }
      
    return $response;
    
}





