<?php
/*
Plugin Name: WooCommerce compatibility for Schema
Description: Addon for Schema & Structured Data for WP & AMP
Version: 1.9
Text Domain: woocommerce-compatibility-for-schema
Domain Path: /languages
Author: Magazine3
License: GPL2
*/
// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) exit;

define('SASWP_WOOCOMMERCE_VERSION', '1.9');
define('SASWP_WOOCOMMERCE_DIR_NAME_FILE', __FILE__ );
define('SASWP_WOOCOMMERCE_DIR_NAME', dirname( __FILE__ ));
define('SASWP_WOOCOMMERCE_DIR_URI', plugin_dir_url(__FILE__));
define('SASWP_WOOCOMMERCE_PLUGIN_URL', plugin_dir_url( __FILE__ ));

require_once SASWP_WOOCOMMERCE_DIR_NAME.'/admin/admin.php';
require_once SASWP_WOOCOMMERCE_DIR_NAME.'/output/service.php';
require_once SASWP_WOOCOMMERCE_DIR_NAME.'/output/output.php';

//Plugin Updater code starts here

// this is the URL our updater / license checker pings. This should be the URL of the site with EDD installed
define( 'SASWP_WOOCOMMERCE_DATA_STORE_URL', 'http://structured-data-for-wp.com/' );

// the name of your product. This should match the download name in EDD exactly
define( 'SASWP_WOOCOMMERCE_DATA_ITEM_NAME', 'Woocommerce compatibility for Schema' );

// the download ID. This is the ID of your product in EDD and should match the download ID visible in your Downloads list (see example below)

// the name of the settings page for the license input to be displayed
define( 'SASWP_WOOCOMMERCE_LICENSE_PAGE', 'woocommerce-compatibility-for-schema' );
if(! defined('SASWP_WOOCOMMERCE_ITEM_FOLDER_NAME')){
    $folderName = basename(__DIR__);
    define( 'SASWP_WOOCOMMERCE_ITEM_FOLDER_NAME', $folderName );
}

require_once dirname( __FILE__ ) . '/updater/EDD_SL_Plugin_Updater.php'; 

function woocommerce_compatibility_for_schema_updater(){
   
        $selectedOption      = get_option('sd_data',true);                
        $license_key         = isset($selectedOption['woocommerce_addon_license_key'])? $selectedOption['woocommerce_addon_license_key']:'';        
        $licensestatus       = isset($selectedOption['woocommerce_addon_license_key_status'])? $selectedOption['woocommerce_addon_license_key_status']:'';

 
// setup the updater
  $edd_updater = new Woocommerce_Data_EDD_SL_Plugin_Updater( SASWP_WOOCOMMERCE_DATA_STORE_URL, __FILE__, array(
      'version'         => SASWP_WOOCOMMERCE_VERSION,      // current version number
      'license'         => $license_key,             // license key (used get_option above to retrieve from DB)
      'license_status'  => $licensestatus,
      'item_name'       => SASWP_WOOCOMMERCE_DATA_ITEM_NAME,      // name of this plugin
      'author'          => 'Magazine3',           // author of this plugin
      'beta'            => false,
    )
  );      
}

add_action( 'admin_init', 'woocommerce_compatibility_for_schema_updater', 0);

// Notice to enter license key once activate the plugin
   $path = plugin_basename( __FILE__ );
   
  add_action("after_plugin_row_{$path}", function( $plugin_file, $plugin_data, $status ) {
   // global $redux_builder_amp;
    
        if(! defined('SASWP_WOOCOMMERCE_ITEM_FOLDER_NAME')){
            
        $folderName = basename(__DIR__);
            define( 'SASWP_WOOCOMMERCE_ITEM_FOLDER_NAME', $folderName );
            
        }
        
        $selectedOption      = get_option('sd_data',true);                        
        $licensestatus       = isset($selectedOption['woocommerce_addon_license_key_status'])? $selectedOption['woocommerce_addon_license_key_status']:'';
        $license_key         = isset($selectedOption['woocommerce_addon_license_key'])? $selectedOption['woocommerce_addon_license_key']:''; 
                        
         if(empty($license_key)){
             
            echo "<tr class='active'><td>&nbsp;</td><td colspan='2'><a href='".esc_url(  self_admin_url( 'admin.php?page=structured_data_options&tab=premium_features#woocommerce_addon_license_key' )  )."'>Please enter the license key</a> to get the <strong>latest features</strong> and <strong>stable updates</strong></td></tr>";
            
         }elseif($licensestatus=="active"){
                          
            $update_cache = get_site_transient( 'update_plugins' );
                                   
            $update_cache = is_object( $update_cache ) ? $update_cache : new stdClass();
            
            if(isset($update_cache->response[ SASWP_WOOCOMMERCE_ITEM_FOLDER_NAME."/".SASWP_WOOCOMMERCE_ITEM_FOLDER_NAME.".php" ]) 
                && empty($update_cache->response[ SASWP_WOOCOMMERCE_ITEM_FOLDER_NAME."/".SASWP_WOOCOMMERCE_ITEM_FOLDER_NAME.".php" ]->download_link) 
             )
                    
            {
               unset($update_cache->response[ SASWP_WOOCOMMERCE_ITEM_FOLDER_NAME."/".SASWP_WOOCOMMERCE_ITEM_FOLDER_NAME.".php" ]);
            }
            
            set_site_transient( 'update_plugins', $update_cache );
            
        }
    }, 10, 3 );

//Plugin Updater code ends here