<?php

/**
 * Single variation cart button
 *
 * @see https://woo.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 7.0.1
 */

defined('ABSPATH') || exit;

global $product;
$base_url = get_home_url(null, '', 'https');


$addons_group2 = null;

$category = get_term_by('slug', 'ADDONS', 'product_cat');
if ($category) {
    $args = array(
        'post_type' => 'product',
        'posts_per_page' => -1,
        'tax_query' => array(
            array(
                'taxonomy' => 'product_cat',
                'field' => 'term_id',
                'terms' => $category->term_id,
            ),
        ),
    );
    $products_query = new WP_Query($args);
}
?>



<div class="woocommerce-variation-add-to-cart variations_button">


    <!-- PRODUCT ID ADD -->
    <div class="addons hidden1">
        ADDONS:

        <script>
            const base_url = "<?= $base_url ?>";
            jQuery(document).ready(function($) {

                jQuery('select#pa_how-many-days').on('change', function() {
                    jQuery('.addons').removeClass('hidden');
                    var option = jQuery(this).find(":selected").val();
                    var text = jQuery(this).find(":selected").text();
                    var posicao = jQuery(this)[0].selectedIndex;


                    var authCode = btoa(
                        'ck_947981e7fe4c1e9c2ebb4e96b540db54d1852fa9:cs_fcd22dba2b46820e5bd8c33d4a00050bf225567c'
                    );

                    //WETSUIT or //BOOTS
                    $('.addons_variation').each(function() {
                        const slug = $(this).data('slug');

                        jQuery.ajax({
                            url: base_url + '/wp-json/wc/v3/products?slug=' + slug,
                            method: 'GET',
                            headers: {
                                'Authorization': "Basic " + authCode
                            },
                            success: function(data) {
                                get_variation(data[0].variations[posicao - 1],
                                    slug, posicao);
                            }
                        });
                    });

                    function get_variation(id, classdiv, dias) {

                        jQuery.ajax({
                            url: base_url + '/wp-json/wc/v3/products/' + id,
                            method: 'GET',
                            headers: {
                                'Authorization': "Basic " + authCode
                            },
                            success: function(data) {

                                jQuery('li.' + classdiv + ' input[type="hidden"]').val(data.id);
                                jQuery('li.' + classdiv + ' .days-price .price').text(data
                                    .price + '€');
                                jQuery('li.' + classdiv + '').attr('data-price', data.price);

                                jQuery('li.' + classdiv + " .days-price .dias").text(dias +
                                    ' days / ');
                                //jQuery('li.'+classdiv+' .days-price .price').text(data.price);

                            }
                        });
                    }

                    function updatePrice() {
                        var producto = jQuery('.woocommerce-variation-price .woocommerce-Price-amount bdi')
                            .text();
                        producto = parseFloat(producto.replace('€', ''));

                        if (jQuery('#wetsuit-check').is(":checked")) {
                            console.log('selecionado');
                            var websuit = parseFloat(jQuery('.wetsuit').attr('data-price'));
                        } else {
                            var websuit = 0;
                        }
                        if (jQuery('#boots-check').is(":checked")) {
                            var boots = parseFloat(jQuery('.boots').attr('data-price'));
                        } else {
                            var boots = 0;
                        }

                        var new_total = producto + websuit + boots;

                        jQuery('span.preco-total').text(new_total);
                    }
                    jQuery('div.addons').on('DOMSubtreeModified', function() {

                        updatePrice();

                    });
                    jQuery('input[type=checkbox]').change(function() {

                        updatePrice();

                    });


                    //jQuery('.days-price').text(text +' | ');

                });

            });
        </script>

        <ul style="list-style: none; margin:0; padding: 0;">
            <?php
            if (isset($products_query) && $products_query->have_posts()) {
                // Loop pelos produtos
                while ($products_query->have_posts()) {
                    $products_query->the_post();
                    $product_id = get_the_ID();

                    $product_slug = get_post_field('post_name', $product_id);

                    /*
				'id'=>get_the_ID(),
				'title'=>get_the_title(),
				'product_slug'=>$product_slug,
				*/
                    if ($product_slug == 'wetsuit' || $product_slug == 'boots') {
            ?>
                        <li class="<?= $product_slug ?> addons_variation" data-slug="<?= $product_slug ?>" data-price="" style="list-style: none; margin:20px 0; padding: 0;display:flex;    align-items: center;">
                            <input type="hidden" name="<?= $product_id ?>-variation" value="">
                            <input type="checkbox" id="<?= $product_slug ?>-check" name="addons_variation[]" value="<?= $product_id ?>" style="margin:0 10px;padding:0;">
                            <label for="" style="margin:0;"><?= get_the_title() ?></label>
                            <div class="days-price" style="margin:0 10px;">
                                <span class="dias"></span>
                                <span class="price"></span>
                            </div>
                            <select name="" id="" style="margin:0;width:150px;">
                                <option value="">S</option>
                                <option value="">M</option>
                                <option value="">L</option>
                                <option value="">XL</option>
                            </select>
                        </li>
            <?php
                    } else {
                        $product = wc_get_product($product_id);
                        $product_price = $product->get_price();
                        $addons_group2 .= "<li>" . get_the_title() . ' <input type="checkbox" id="' . $product_slug . '" name="' . $product_slug . '" value="' . $product_slug . '" style="margin:0 10px;padding:0;">(' . $product_price . '€)</li>';
                    }
                }
                wp_reset_postdata(); // Restaura os dados do post original
            }
            ?>


            <ul style="list-style: none; margin:20px 0; padding: 0;display:flex;align-items: center;">
                <?= $addons_group2 ?>
            </ul>
            </li>


        </ul>

    </div>
    <!-- -->

    <?php do_action('woocommerce_before_add_to_cart_button'); ?>
    <?php
    do_action('woocommerce_before_add_to_cart_quantity');

    woocommerce_quantity_input(
        array(
            'min_value'   => apply_filters('woocommerce_quantity_input_min', $product->get_min_purchase_quantity(), $product),
            'max_value'   => apply_filters('woocommerce_quantity_input_max', $product->get_max_purchase_quantity(), $product),
            'input_value' => isset($_POST['quantity']) ? wc_stock_amount(wp_unslash($_POST['quantity'])) : $product->get_min_purchase_quantity(), // WPCS: CSRF ok, input var ok.
        )
    );

    do_action('woocommerce_after_add_to_cart_quantity');
    ?>

    <button type="submit" class="single_add_to_cart_button button alt<?php echo esc_attr(wc_wp_theme_get_element_class_name('button') ? ' ' . wc_wp_theme_get_element_class_name('button') : ''); ?>"><?php echo esc_html($product->single_add_to_cart_text()); ?></button>
    <h4>Preço Total: <span class="preco-total"></span>€</h4>
    <?php do_action('woocommerce_after_add_to_cart_button'); ?>

    <input type="hidden" name="add-to-cart" value="<?php echo absint($product->get_id()); ?>" />
    <input type="hidden" name="product_id" value="<?php echo absint($product->get_id()); ?>" />
    <input type="hidden" name="variation_id" class="variation_id" value="0" />
</div>