<?php
add_filter('thwcfe_show_field', 'th73mng_override_show_field', 99, 2);
function th73mng_override_show_field($show, $field_name)
{

    if (!is_checkout()) {
        return $show;
    }

    if ($field_name != 'suit') { // Update your field name
        return $show;
    }

    if (WC()->cart->is_empty()) {
        return $show;
    }

    $show = false;
    $cart = WC()->cart->get_cart();
    foreach ($cart as $cart_item) {

        $item_data = $cart_item['data'];
        $attributes = $item_data->get_attributes();

        if (!empty ($attributes)) {

            foreach ($attributes as $attribute_name => $attribute) {
                if (!is_object($attribute) && !($attribute instanceof WC_Product_Attribute)) {
                    if ($attribute_name == "pa_with-wetsuit" && $attribute == "with-wetsuit") { // Update your attribute name & attribute value
                        $show = true;
                        return $show;
                    }
                }
            }
        }
    }
    return $show;
}

// Add custom Theme Functions here
add_action('wp_enqueue_scripts', 'my_plugin_enqueue_scripts');
function my_plugin_enqueue_scripts()
{
    // Adiciona o estilo CSS
    wp_enqueue_style('my-style', get_stylesheet_directory_uri() . '/style.css', false, '1.0', 'all');

    // Adiciona o script JavaScript
    wp_enqueue_script('my-script', get_stylesheet_directory_uri() . '/script.js', array('jquery'), '1.0', true);
}

/** Remove product data tabs */

add_filter('woocommerce_product_tabs', 'my_remove_product_tabs', 98);

function my_remove_product_tabs($tabs)
{
    unset($tabs['additional_information']); // To remove the additional information tab
    return $tabs;
}

//Remove title hook and add in a new one with the product categories added
remove_action('woocommerce_shop_loop_item_title', 'woocommerce_template_loop_product_title', 10);
add_action('woocommerce_shop_loop_item_title', 'VS_woo_loop_product_title', 10);

function VS_woo_loop_product_title()
{
    /*if (!isset ($post))
        return;*/
    $terms = get_the_terms($post->ID, 'product_cat');
    if ($terms && !is_wp_error($terms)):
        // only displayed if the product has at least one category
        $cat_links = array();
        foreach ($terms as $term) {
            $cat_links[] = '<a class="category uppercase is-smaller no-text-overflow product-cat op-7" href="' . esc_url(home_url()) . '/surfboard-category/' . $term->slug . '">' . $term->name . '</a>';
        }
        $on_cat = join("<a class='category uppercase is-smaller no-text-overflow product-cat op-7'>,</a> ", $cat_links);
        ?>
        <style type="text/css">
            .title-wrapper p.category {
                display: none;
            }
        </style>
        <div class="label-group">
            <div class="categories-link">
                <?php echo $on_cat; ?>
            </div>
        </div>
        <?php
        echo '<a href="' . get_permalink() . '" class="woocommerce-LoopProduct-link woocommerce-loop-product__link">' . get_the_title() . '</a>';
    endif;
}


// To change add to cart text on single product page
add_filter('woocommerce_product_single_add_to_cart_text', 'woocommerce_custom_single_add_to_cart_text');
function woocommerce_custom_single_add_to_cart_text()
{
    return __('BOOK NOW', 'woocommerce');
}

// To change add to cart text on product archives(Collection) page
add_filter('woocommerce_product_add_to_cart_text', 'woocommerce_custom_product_add_to_cart_text');
function woocommerce_custom_product_add_to_cart_text()
{
    return __('BOOK NOW', 'woocommerce');
}

// Change WooCommerce "Related products" text

add_filter('gettext', 'change_rp_text', 10, 3);
add_filter('ngettext', 'change_rp_text', 10, 3);

function change_rp_text($translated, $text, $domain)
{
    if ($text === 'Related products' && $domain === 'woocommerce') {
        $translated = esc_html__('RELATED SURFBOARDS', $domain);
    }
    return $translated;
}



function njengah_custom_change_cart_string($translated_text, $text, $domain)
{

    $translated_text = str_replace("view basket", "VIEW CART", $translated_text);

    $translated_text = str_replace("View basket", "VIEW CART", $translated_text);

    return $translated_text;
}

add_filter('gettext', 'njengah_custom_change_cart_string', 100, 3);

add_filter('ngettext', 'njengah_custom_change_cart_string', 100, 3);


//--- HIDE ADDONS CAT DOMINGEZ --//
/// variation-add-to-cart

add_action('woocommerce_add_to_cart', 'custom_add_to_cart_addons');
function custom_add_to_cart_addons()
{
    //WETSUIT or //BOOTS
    if (isset ($_POST['addons_variation']) && is_array($_POST['addons_variation'])) {

        $addons_variation = $_POST['addons_variation'];
        unset($_POST['addons_variation']);
        foreach ($addons_variation as $product_id) {

            $variation_id = $_POST[$product_id . '-variation'];
            //$quantity = $_POST['quantity'] ?? 1;
            $quantity = 1;
            $found = false;


            /*
             foreach (WC()->cart->get_cart() as $cart_item_key => $values) {
                 $_product = $values['data'];
                 if ($_product->id == $product_id)
                     $found = true;
             }
            */

            if (!$found) {
                if (isset ($_POST[$product_id . '-variation_size']))
                    $arrOthers = array('add_size' => array('size' => $_POST[$product_id . '-variation_size']));
                else
                    $arrOthers = array();
                WC()->cart->add_to_cart($product_id, $quantity, $variation_id, array(), $arrOthers);
            }
        }
    }

    //addons_simple
    if (isset ($_POST['addons_simple']) && is_array($_POST['addons_simple'])) {

        $addons_variation = $_POST['addons_simple'];
        unset($_POST['addons_simple']);
        foreach ($addons_variation as $product_id) {


            $quantity = 1;
            $found = false;
            $slugs_array = array('pack-explorer', 'roof-rack', 'locker');
            $product_slug = get_post_field('post_name', $product_id);

            if (in_array($product_slug, $slugs_array)) {

                foreach (WC()->cart->get_cart() as $cart_item_key => $values) {
                    $_product = $values['data'];
                    if ($_product->id == $product_id)
                        $found = true;
                }
            }

            if (!$found) {
                WC()->cart->add_to_cart($product_id, $quantity);
            }
        }
    }
}
add_action('wp_footer', 'my_custom_modal_html');
function my_custom_modal_html()
{
    ?>
    <script>
        function showAlertPopUp(data) {
            jQuery('#mymodal_popup_alert .msg').html(data.msg)
            jQuery('#mymodal_popup_alert').addClass('active')
            jQuery('#mymodal_popup_alert .button.primary').attr('data-calback', data.calback ?? null);
            jQuery('#mymodal_popup_alert .button.primary').html(data.btn_primary_text ?? ' I Agree ');


            console.log(data.show_btn_change_location ?? null)
            if (data.show_btn_change_location ?? null) jQuery('#mymodal_popup_alert .button.secundary').removeClass("hidden");

            else jQuery('#mymodal_popup_alert .button.secundary').addClass("hidden");


        }
        jQuery(document).ready(function () {

            jQuery('#mymodal_popup_alert .button.secundary').on('click', function () {

                jQuery('#mymodal_popup_alert').removeClass('active');
                jQuery('.checkout_pickup_location').val('');
                jQuery('.checkout_drop_off_location').val('');
                //updateCheckoutFee();
                jQuery('body').trigger('update_checkout');
            });



            jQuery('#mymodal_popup_alert .button.primary').on('click', function () {
                let callbackName = jQuery('#mymodal_popup_alert .button.primary').attr('data-calback');
                if (callbackName && window[callbackName] && typeof window[callbackName] === 'function') {
                    window[callbackName](); // Chamada da função de callback
                }
                jQuery('#mymodal_popup_alert').removeClass('active');

            });
        });
    </script>

    <div id="mymodal_popup_alert" class="modal_popup_alert">

        <!-- modal_popup_alert content -->
        <div class="modal_popup_alert-content">
            <div class="icon">
                <svg width="60px" heigth="60px" xmlns="http://www.w3.org/2000/svg"
                    class="bi bi-exclamation-triangle-fill flex-shrink-0 me-2" viewBox="0 0 16 16" role="img"
                    aria-label="Warning:">
                    <path
                        d="M8.982 1.566a1.13 1.13 0 0 0-1.96 0L.165 13.233c-.457.778.091 1.767.98 1.767h13.713c.889 0 1.438-.99.98-1.767L8.982 1.566zM8 5c.535 0 .954.462.9.995l-.35 3.507a.552.552 0 0 1-1.1 0L7.1 5.995A.905.905 0 0 1 8 5zm.002 6a1 1 0 1 1 0 2 1 1 0 0 1 0-2z" />
                </svg>
            </div>
            <div class="msg"></div>

            <div class="actions">
                <button type="button" class="button primary is-gloss" data-calback=""> I Agree</button>
                <button type="button" class="button  secundary is-gloss hidden" data-calback=""> Change location</button>
            </div>
        </div>

    </div>

    <?php
}


//checkout_pickup_location
add_action('woocommerce_checkout_before_customer_details', 'my_custom_checkout_html');
function my_custom_checkout_html()
{

    $saved_dynamic_data = get_option('cxc_dynamic_fields_data');


    foreach ($saved_dynamic_data as $key => $field) {

        $cxc_dynamic_field_localization = str_replace("\n", "", preg_replace("/\r|\n/", "", $field['cxc_dynamic_field_localization']));
        $cxc_dynamic_field_message = str_replace("\n", "", preg_replace("/\r|\n/", "", $field['cxc_dynamic_field_message']));
        $cxc_dynamic_field_show_btn_change_location = $field['cxc_dynamic_field_show_btn_change_location_' . $key];

        if ($field['cxc_dynamic_fields_when'] == "pick_up") {
            if ($field['cxc_dynamic_field_except_product'] && $arr_except_product = explode(PHP_EOL, $field['cxc_dynamic_field_except_product'])) {
                $except_product = false;

                $except_product = is_product_url_in_cart($arr_except_product);
                if ($except_product)
                    continue;
            }



            ?>
            <script>
                jQuery(document).ready(function () {
                    jQuery('.checkout_pickup_location').on('change', function () {

                        if ('<?= $cxc_dynamic_field_localization ?>'.includes(jQuery(this).val()))
                            showAlertPopUp({
                                msg: "<?= $cxc_dynamic_field_message ?>",
                                show_btn_change_location: "<?= $cxc_dynamic_field_show_btn_change_location ?>",
                                calback: "checkout_add_fee",
                            })
                        else updateCheckoutFee()
                    });

                });
            </script>


            <?php
        }
        //drop_off
        else if ($field['cxc_dynamic_fields_when'] == "drop_off") {
            if ($field['cxc_dynamic_field_except_product'] && $arr_except_product = explode(PHP_EOL, $field['cxc_dynamic_field_except_product'])) {

                $except_product = is_product_url_in_cart($arr_except_product);
                if ($except_product)
                    continue;
            }



            ?>
                <script>
                    jQuery(document).ready(function () {
                        jQuery('.checkout_drop_off_location').on('change', function () {

                            if ('<?= $cxc_dynamic_field_localization ?>'.includes(jQuery(this).val()))
                                showAlertPopUp({
                                    msg: "<?= $cxc_dynamic_field_message ?>",
                                    show_btn_change_location: "<?= $cxc_dynamic_field_show_btn_change_location ?>",
                                    calback: "checkout_add_fee",
                                })
                        });

                    });
                </script>


            <?php
        }

        //pick_up_diferent_drop_off
        else if ($field['cxc_dynamic_fields_when'] == "pick_up_diferent_drop_off") {
            if ($field['cxc_dynamic_field_except_product'] && $arr_except_product = explode(PHP_EOL, $field['cxc_dynamic_field_except_product'])) {

                $except_product = is_product_url_in_cart($arr_except_product);
                if ($except_product)
                    continue;
            }


            ?>
                    <script>
                        jQuery(document).ready(function () {
                            jQuery('.checkout_drop_off_location').on('change', function () {

                                if (jQuery(this).val() && (jQuery(this).val() != jQuery(".checkout_pickup_location").val()) &&
                                    '<?= $cxc_dynamic_field_localization ?>'
                                        .includes(jQuery(this)
                                            .val()))
                                    showAlertPopUp({
                                        msg: "<?= $cxc_dynamic_field_message ?>",
                                        show_btn_change_location: "<?= $cxc_dynamic_field_show_btn_change_location ?>",
                                        calback: "checkout_add_fee",
                                    });

                                else updateCheckoutFee()
                            });

                        });
                    </script>


            <?php
        }
    }
}


add_filter('woocommerce_settings_tabs_array', 'cxc_add_settings_tab', 50);
function cxc_add_settings_tab($settings_tabs)
{
    $settings_tabs['cxc_settings_tabs'] = __('Checkout', 'special-delivery-fee');
    return $settings_tabs;
}

add_action('woocommerce_settings_tabs_cxc_settings_tabs', 'cxc_settings_tab');
function cxc_settings_tab()
{
    woocommerce_admin_fields(cxc_get_settings());
    ?>
    <script>
        jQuery(document).ready(function ($) {
            // Adicionar campo dinâmico ao clicar no botão "Adicionar mais"
            $(document).on('click', '.add-more', function () {
                var $template = $('#dynamic-field-template').clone();
                $template.removeAttr('id');
                let newIndex = $('#dynamic-fields-container').find('tr').length - 1;
                $template.find('input[type="checkbox"]').each(function () {

                    var newName = $(this).attr('name') + newIndex;
                    $(this).attr('name', newName);
                });

                $template.appendTo('#dynamic-fields-container').show();
            });

            // Remover campo dinâmico ao clicar no botão "Remover"
            $(document).on('click', '.remove-field', function () {
                $(this).closest('.dynamic-field').remove();
            });
        });
    </script>
    <?php
}

function cxc_get_settings()
{

    $field_types = [
        'pick_up' => 'Pick-up',
        'drop_off' => 'Drop-off',
        'pick_up_diferent_drop_off' => 'Pick-up != Drop-off',
    ];
    // Recuperar os dados salvos da base de dados
    $saved_dynamic_data = get_option('cxc_dynamic_fields_data');

    // Inicializar a variável que irá armazenar os campos dinâmicos HTML
    $dynamic_fields_html = '';

    // Verificar se existem dados salvos
    if (!empty ($saved_dynamic_data)) {
        // Iterar sobre os dados salvos para criar os campos dinâmicos HTML preenchidos
        $index = 0;
        foreach ($saved_dynamic_data as $key => $field) {

            $dynamic_fields_html .= '<tr class="dynamic-field">';

            $dynamic_fields_html .= '<td> <select style=" width :98% "  name="cxc_dynamic_fields_when[]" > ';

            foreach ($field_types as $key => $field_type) {
                $dynamic_fields_html .= '<option  ' . ($key == esc_attr($field['cxc_dynamic_fields_when'] ?? null) ? "selected" : "") . '  value="' . $key . '">' . $field_type . '</option>';
            }
            $dynamic_fields_html .= '</select></td>';


            $dynamic_fields_html .= '<td><textarea rows="4"  style=" width :98% " name="cxc_dynamic_field_localization[]">' . ($field['cxc_dynamic_field_localization'] ?? null) . '</textarea></td>';

            $dynamic_fields_html .= '<td><textarea rows="4"  style=" width :98% " name="cxc_dynamic_field_message[]">' . ($field['cxc_dynamic_field_message'] ?? null) . '</textarea></td>';
            $dynamic_fields_html .= '<td><input  style=" width :80px "  value="' . ($field['cxc_dynamic_field_delivery_fee'] ?? null) . '"  type="number"  name="cxc_dynamic_field_delivery_fee[]' . $index . '"/></td>';
            $dynamic_fields_html .= '<td><input  style=" width :120px "  value="' . ($field['cxc_dynamic_field_delivery_fee_name'] ?? null) . '"  type="text"  name="cxc_dynamic_field_delivery_fee_name[]' . $index . '"/></td>';

            $dynamic_fields_html .= '<td><textarea rows="4"  style=" width :98% " name="cxc_dynamic_field_except_product[]">' . ($field['cxc_dynamic_field_except_product'] ?? null) . '</textarea></td>';

            $dynamic_fields_html .= '<td style=" text-align: center;"><input class="cxc_dynamic_field_show_in_email" ' . (($field['cxc_dynamic_field_show_in_email_' . $index] ?? null) ? "checked" : "") . '  type="checkbox"  name="cxc_dynamic_field_show_in_email_' . $index . '"/></td>';

            $dynamic_fields_html .= '<td style=" text-align: center;"><input class="cxc_dynamic_field_add_value_to_card"  ' . (($field['cxc_dynamic_field_add_value_to_card_' . $index] ?? null) ? "checked" : "") . '  type="checkbox"  name="cxc_dynamic_field_add_value_to_card_' . $index . '"/></td>';
            $dynamic_fields_html .= '<td style=" text-align: center;"><input  ' . (($field['cxc_dynamic_field_show_btn_change_location_' . $index] ?? null) ? "checked" : "") . '  type="checkbox"  name="cxc_dynamic_field_show_btn_change_location_' . $index . '"/></td>';


            $dynamic_fields_html .= '<td><button type="button" class="remove-field">' . esc_html__('Remove', 'special-delivery-fee') . '</button></td>';
            $dynamic_fields_html .= '</tr>';
            $index++;
        }
    }

    ob_start();
    ?>
    <h2>Special delivery fee</h2>
    <table class="wc_checkout widefat" cellspacing="0">
        <thead>
            <tr>
                <th>When</th>
                <th>localization</th>
                <th>Message</th>
                <th>Delivery Fee</th>
                <th>Fee Name</th>
                <th>except product</th>
                <th style=" text-align: center;">Show in Email</th>

                <th style=" text-align: center;">Add to Cart(Fee)</th>
                <th style=" text-align: center;">Show btn Change location</th>
                <th>Option</th>
            </tr>
        </thead>
        <tbody id="dynamic-fields-container">


            <!-- Template para campo dinâmico -->
            <tr class="dynamic-field" id="dynamic-field-template" style="display: none;">
                <td>
                    <select style=" width :98% " name="cxc_dynamic_fields_when[]">
                        <?php
                        foreach ($field_types as $key => $field_type): ?>
                            <option value="<?= $key ?>">
                                <?= $field_type ?>
                            </option>
                        <?php endforeach;
                        ?>

                    </select>
                </td>

                <td><textarea rows="4" style=" width :98% " name="cxc_dynamic_field_localization[]"></textarea> </td>
                <td><textarea rows="4" style=" width :98% " name="cxc_dynamic_field_message[]"></textarea> </td>
                <td><input style=" width :80px " type="number" name="cxc_dynamic_field_delivery_fee[]" /></td>
                <td><input style=" width :120px " type="text" name="cxc_dynamic_field_delivery_fee_name[]" /></td>
                <td><textarea rows="4" style=" width :98% " name="cxc_dynamic_field_except_product[]"></textarea> </td>
                <td style=" text-align: center;"><input type="checkbox" class="cxc_dynamic_field_show_in_email"
                        name="cxc_dynamic_field_show_in_email_"></td>
                <td style=" text-align: center;"><input type="checkbox" class="cxc_dynamic_field_add_value_to_card"
                        name="cxc_dynamic_field_add_value_to_card_"></td>
                <td style=" text-align: center;"><input type="checkbox" name="cxc_dynamic_field_show_btn_change_location_">
                </td>

                <td> <button type="button" class="remove-field">
                        <?php esc_html_e('Remove', 'special-delivery-fee'); ?>
                    </button>

                </td>
            </tr>

            <!-- Campos dinâmicos preenchidos com os dados salvos -->
            <?php echo $dynamic_fields_html; ?>

        </tbody>
    </table>

    <br>
    <!-- Botão para adicionar mais campos -->
    <button type="button" class="add-more button-primary woocommerce-save-button">
        <?php esc_html_e('Add More', 'special-delivery-fee'); ?>
    </button>
    <script>
        jQuery(document).ready(function () {

            jQuery("tr").each(function () {

                var checkbox = jQuery(this).find(".cxc_dynamic_field_add_value_to_card");
                if (checkbox.prop("checked")) {

                    jQuery(this).find(".cxc_dynamic_field_show_in_email").prop(
                        "readonly",
                        true);
                } else {

                    jQuery(this).find(".cxc_dynamic_field_show_in_email").prop(
                        "readonly",
                        false);
                }
            });


            jQuery(".cxc_dynamic_field_add_value_to_card").change(function () {
                if (jQuery(this).is(":checked")) {

                    jQuery(this).closest("tr").find(".cxc_dynamic_field_show_in_email").prop("disabled", true);
                } else {

                    jQuery(this).closest("tr").find(".cxc_dynamic_field_show_in_email").prop("disabled", false);
                }
            });
        });
    </script>
    <?php

    return apply_filters('wc_cxc_settings_tabs_settings', array());
}

add_action('woocommerce_update_options_cxc_settings_tabs', 'cxc_update_settings');
function cxc_update_settings()
{
    // Verifica se os campos dinâmicos foram enviados
    if (isset ($_POST['cxc_dynamic_field_localization'])) {
        // Obtém os campos dinâmicos

        $cxc_dynamic_field_localization = $_POST['cxc_dynamic_field_localization'];
        $cxc_dynamic_fields_when = $_POST['cxc_dynamic_fields_when'];
        $cxc_dynamic_field_message = $_POST['cxc_dynamic_field_message'];
        $cxc_dynamic_field_except_product = $_POST['cxc_dynamic_field_except_product'];
        $cxc_dynamic_field_delivery_fee = $_POST['cxc_dynamic_field_delivery_fee'];
        $cxc_dynamic_field_delivery_fee_name = $_POST['cxc_dynamic_field_delivery_fee_name'];


        // Combina os campos dinâmicos em um array associativo
        $dynamic_data = array();
        $index = 0;
        foreach ($cxc_dynamic_field_localization as $key => $field) {
            if (!($cxc_dynamic_field_localization[$key] ?? null))
                continue;
            $dynamic_data[] = [
                'cxc_dynamic_fields_when' => $cxc_dynamic_fields_when[$key] ?? null,
                'cxc_dynamic_field_localization' => $cxc_dynamic_field_localization[$key] ?? null,
                'cxc_dynamic_field_message' => $cxc_dynamic_field_message[$key] ?? null,
                'cxc_dynamic_field_except_product' => $cxc_dynamic_field_except_product[$key] ?? null,
                'cxc_dynamic_field_delivery_fee' => $cxc_dynamic_field_delivery_fee[$key] ?? null,
                'cxc_dynamic_field_delivery_fee_name' => $cxc_dynamic_field_delivery_fee_name[$key] ?? null,

                'cxc_dynamic_field_show_in_email_' . $index => $_POST['cxc_dynamic_field_show_in_email_' . $index] ?? null,
                'cxc_dynamic_field_add_value_to_card_' . $index => $_POST['cxc_dynamic_field_add_value_to_card_' . $index] ?? null,
                'cxc_dynamic_field_show_btn_change_location_' . $index => $_POST['cxc_dynamic_field_show_btn_change_location_' . $index] ?? null,
            ];
            $index++;
        }

        // Salva os dados dos campos dinâmicos
        update_option('cxc_dynamic_fields_data', $dynamic_data);
    }
}


function is_product_url_in_cart($arr_except_product)
{
    $result = false;
    $cart_items = WC()->cart->get_cart_contents();

    foreach ($cart_items as $item) {
        $product = wc_get_product($item['product_id']);
        $exist = false;
        if ($product && has_term('addons', 'product_cat', $item['product_id']))
            continue;
        foreach ($arr_except_product as $data) {

            if ($product && stripos($product->get_permalink(), $data) !== false)
                $result = $exist = true;
        }
        if (!$exist)
            return false;
    }

    return $result;
}

// jQuery - Ajax script
add_action('wp_footer', 'checkout_shipping_packing_script');
function checkout_shipping_packing_script()
{
    // Only checkout page
    if (is_checkout() && !is_wc_endpoint_url()):
        ?>
        <script type="text/javascript">
            var needdUpdateCheckoutFee_value = false

            function checkout_add_fee() {
                needdUpdateCheckoutFee_value = true;
                jQuery('body').trigger('update_checkout');

            }

            function updateCheckoutFee() {
                if (needdUpdateCheckoutFee_value === true) {
                    needdUpdateCheckoutFee_value = false
                    jQuery('body').trigger('update_checkout');

                }


            }
        </script>
        <?php

    endif;
}


// Add a custom dynamic packaging fee
add_action('woocommerce_cart_calculate_fees', 'add_packaging_fee', 20, 1);
function add_packaging_fee($cart)
{

    if (is_admin() && !defined('DOING_AJAX'))
        return;

    if (isset ($_POST['pickup_location']) && $pickup_location = $_POST['pickup_location']) {
        $drop_off_location = $_POST['drop_off_location'] ?? '';
        checkout_delivery_fee($pickup_location, $drop_off_location, "checkout_delivery_fee_ajax_data");
    } else if (isset ($_POST['post_data'])) {

        parse_str($_POST['post_data'], $post_data);

        if (isset ($post_data['pickup_location']) && $pickup_location = $post_data['pickup_location']) {
            $drop_off_location = $post_data['drop_off_location'] ?? '';
            checkout_delivery_fee($pickup_location, $drop_off_location, "checkout_delivery_fee_ajax_data");
        }
    }
}

// ” para aceitar e a aceitação da taxa deve constar nos emails, mas não acrescenta ao valor ao carrinho.
add_action('woocommerce_email_after_order_table_total', 'add_custom_fee_to_email', 10, 4);
function add_custom_fee_to_email($order, $sent_to_admin, $plain_text, $email)
{
    if ($sent_to_admin)
        return;
    $order_id = $order->get_id();

    $pickup_location = get_post_meta($order_id, 'pickup_location', true);
    $drop_off_location = get_post_meta($order_id, 'drop_off_location', true);

    checkout_delivery_fee($pickup_location, $drop_off_location, "send_email");
}


function checkout_delivery_fee($pickup_location, $drop_off_location, $type_action)
{

    $saved_dynamic_data = get_option('cxc_dynamic_fields_data');

    foreach ($saved_dynamic_data as $key => $field) {

        $cxc_dynamic_field_localization = $field['cxc_dynamic_field_localization'];


        if ($field['cxc_dynamic_field_except_product'] && $arr_except_product = explode(PHP_EOL, $field['cxc_dynamic_field_except_product'])) {


            $except_product = is_product_url_in_cart($arr_except_product);
            if ($except_product)
                continue;


        }

        if ($field['cxc_dynamic_fields_when'] == "pick_up_diferent_drop_off" && $pickup_location != $drop_off_location) {
            $localization = $drop_off_location;
        } else if ($field['cxc_dynamic_fields_when'] == "pick_up")
            $localization = $pickup_location;
        else if ($field['cxc_dynamic_fields_when'] == "drop_off")
            $localization = $drop_off_location;
        else
            return;

        if (!empty ($localization) && strstr(strtolower($cxc_dynamic_field_localization), strtolower($localization)) !== false) {
            if ($type_action == "checkout_delivery_fee_ajax_data" && $field['cxc_dynamic_field_add_value_to_card_' . $key]) {
                WC()->cart->add_fee($field['cxc_dynamic_field_delivery_fee_name'], $field['cxc_dynamic_field_delivery_fee']);
            } else if ($type_action == "send_email" && $field['cxc_dynamic_field_show_in_email_' . $key] && !$field['cxc_dynamic_field_add_value_to_card_' . $key])
                echo '<tr><th class="td" scope="row" colspan="2"style="text-align:left; "> ' . $field['cxc_dynamic_field_delivery_fee_name'] . '</th><td class="td" style="text-align:left">' . wc_price($field['cxc_dynamic_field_delivery_fee']) . '</td></tr>';
        }
    }
}


// Display custom cart item meta data (in cart and checkout)
add_filter('woocommerce_get_item_data', 'display_cart_item_custom_meta_data', 10, 2);
function display_cart_item_custom_meta_data($item_data, $cart_item)
{
    $meta_key = 'size';
    if (isset ($cart_item['add_size']) && isset ($cart_item['add_size'][$meta_key])) {
        $item_data[] = array(
            'key' => $meta_key,
            'value' => $cart_item['add_size'][$meta_key],
        );
    }
    return $item_data;
}

// Save cart item custom meta as order item meta data and display it everywhere on orders and email notifications.
add_action('woocommerce_checkout_create_order_line_item', 'save_cart_item_custom_meta_as_order_item_meta', 10, 4);
function save_cart_item_custom_meta_as_order_item_meta($item, $cart_item_key, $values, $order)
{
    $meta_key = 'size';
    if (isset ($values['add_size']) && isset ($values['add_size'][$meta_key])) {
        $item->update_meta_data($meta_key, $values['add_size'][$meta_key]);
    }
}





/*
hidden addons product
*/

add_action('pre_get_posts', 'exclude_category_from_product_search', 1);
function exclude_category_from_product_search($query)
{

    if ($query->is_main_query() && !is_admin() && class_exists('WooCommerce')) {
        // Obtém a tax_query atual
        $tax_query = $query->get('tax_query');
        if (!is_array($tax_query)) {
            $tax_query = array();
        }
        $tax_query[] = array(
            'taxonomy' => 'product_cat',
            'field' => 'slug',
            'terms' => 'addons',
            'operator' => 'NOT IN',
        );


        $query->set('tax_query', $tax_query);
    }
}



add_filter('pwf_woo_products_loop', 'pwf_consulting_theme_result_count', 10, 3);
function pwf_consulting_theme_result_count($config)
{


    if (is_array($config)) {
        $config['tax_query'][] = array(
            'taxonomy' => 'product_cat',
            'field' => 'slug',
            'terms' => 'addons',
            'operator' => 'NOT IN',
            'include_children' => true
        );
    }
    return $config;
}

add_action('template_redirect', 'hide_products_with_category_from_single_product_page');
function hide_products_with_category_from_single_product_page()
{
    if (is_product()) {
        global $post;
        $product_cats = wp_get_post_terms($post->ID, 'product_cat', array('fields' => 'slugs'));
        if (in_array('addons', $product_cats)) {
            wp_redirect(home_url());
            exit;
        }
    }
}




add_filter('woocommerce_cart_item_quantity', 'disable_quantity_change_for_addons', 10, 2);

function disable_quantity_change_for_addons($product_quantity, $cart_item_key)
{
    // Obter o carrinho atual
    $cart = WC()->cart;

    // Obter os itens do carrinho
    $cart_item = $cart->get_cart_item($cart_item_key);
    $product_id = $cart_item['product_id'];
    $product = wc_get_product($product_id);
    if ($product && has_term('addons', 'product_cat', $product_id) && $product->get_slug() != 'surf-skate') {
        // Se pertencer à categoria "Addons", desativar a capacidade de alterar a quantidade
        return sprintf('<input type="hidden" name="cart[%s][qty]" value="%s" />%s', $cart_item_key, $cart_item['quantity'], $cart_item['quantity']);
    }

    return $product_quantity;
}


// Cart item link
add_filter('woocommerce_cart_item_name', 'conditionally_remove_link_from_cart_item_name', 10, 3);
function conditionally_remove_link_from_cart_item_name($item_name, $cart_item, $cart_item_key)
{
    $product_id = $cart_item['product_id'];
    $product = wc_get_product($product_id);
    if ($product && has_term('addons', 'product_cat', $product_id)) {
        // Se pertencer à categoria "Addons", desativar a capacidade de alterar a quantidade
        $item_name = $cart_item['data']->get_name();
    }

    return $item_name;
}

// Mini-cart item link
add_filter('woocommerce_cart_item_permalink', 'conditionally_remove_cart_item_permalink', 10, 3);
function conditionally_remove_cart_item_permalink($permalink, $cart_item, $cart_item_key)
{
    $product_id = $cart_item['product_id'];
    $product = wc_get_product($product_id);
    if ($product && has_term('addons', 'product_cat', $product_id)) {
        // Se pertencer à categoria "Addons", desativar a capacidade de alterar a quantidade
        $permalink = '';
    }
    return $permalink;
}





/*
Alerta addons carrinho
*/

// Adiciona uma nova aba nas configurações do WooCommerce
add_filter('woocommerce_settings_tabs_array', 'add_custom_settings_tab', 50);
function add_custom_settings_tab($tabs)
{
    $tabs['addons_tab'] = __('Addons', 'woocommerce');
    return $tabs;
}

// Adiciona os campos de texto (textareas) na nova aba
add_action('woocommerce_settings_tabs_addons_tab', 'add_custom_settings_fields');
function add_custom_settings_fields()
{
    ?>
    <h2>
        <?php _e('Already added', 'woocommerce'); ?>
    </h2>
    <table class="form-table">
        <tr valign="top">
            <th scope="row">
                <?php _e('Pack Explorer', 'woocommerce'); ?>
            </th>
            <td><textarea rows="3" name="pack-explorer_already_added" id="pack-explorer_already_added"
                    class="regular-text"><?= get_option('pack-explorer_already_added') ?></textarea></td>
        </tr>
        <tr valign="top">
            <th scope="row">
                <?php _e('Roof Rack', 'woocommerce'); ?>
            </th>
            <td><textarea rows="3" name="roof-rack_already_added" id="roof-rack_already_added"
                    class="regular-text"><?= get_option('roof-rack_already_added') ?></textarea></td>
        </tr>
        <tr valign="top">
            <th scope="row">
                <?php _e('Locker', 'woocommerce'); ?>
            </th>
            <td><textarea rows="3" name="locker_already_added" id="locker_already_added"
                    class="regular-text"><?= get_option('locker_already_added') ?></textarea></td>
        </tr>
        <tr valign="top">
            <th scope="row">
                <?php _e('Locker & Roof Rack', 'woocommerce'); ?>
            </th>
            <td><textarea rows="3" name="locker_roof_already_added" id="locker_roof_already_added"
                    class="regular-text"><?= get_option('locker_roof_already_added') ?></textarea></td>
        </tr>

    </table>

    <h2>
        <?php _e('Already selected', 'woocommerce'); ?>
    </h2>

    <table class="form-table">
        <tr valign="top">
            <th scope="row">
                <?php _e('Pack Explorer', 'woocommerce'); ?>
            </th>
            <td><textarea rows="3" name="pack-explorer_already_selected" id="pack-explorer_already_selected"
                    class="regular-text"><?= get_option('pack-explorer_already_selected') ?></textarea></td>
        </tr>
        <tr valign="top">
            <th scope="row">
                <?php _e('Roof Rack', 'woocommerce'); ?>
            </th>
            <td><textarea rows="3" name="roof-rack_already_selected" id="roof-rack_already_selected"
                    class="regular-text"><?= get_option('roof-rack_already_selected') ?></textarea></td>
        </tr>
        <tr valign="top">
            <th scope="row">
                <?php _e('Locker', 'woocommerce'); ?>
            </th>
            <td><textarea rows="3" name="locker_already_selected" id="locker_already_selected"
                    class="regular-text"><?= get_option('locker_already_selected') ?></textarea></td>
        </tr>
        <tr valign="top">
            <th scope="row">
                <?php _e('Locker & Roof Rack', 'woocommerce'); ?>
            </th>
            <td><textarea rows="3" name="locker_roof_already_selected" id="locker_roof_already_selected"
                    class="regular-text"><?= get_option('locker_roof_already_selected') ?></textarea></td>
        </tr>

    </table>

    <h2>
        <?php _e('Already selecte22d', 'woocommerce');


        $image_id = get_option('imaege_addons_brand_onrill');
        $image_url = wp_get_attachment_url($image_id);
        ?>
    </h2>

    <button id="upload_button_imaege_addons_brand_onrill" class="button">Carregar Imagem</button>
    <img id="image_url_imaege_addons_brand_onrill" src="<?= esc_url($image_url) ?>"
        style="max-width: 200px; height: auto;" />
    <input type="hidden" id="imaege_addons_brand_onrill" name="imaege_addons_brand_onrill"
        value="<?= esc_url($image_id) ?>">
    <script>
        jQuery(document).ready(function () {
            jQuery('#upload_button_imaege_addons_brand_onrill').on('click', function (e) {
                e.preventDefault();

                var customUploader = wp.media({
                    title: 'Escolha uma imagem',
                    button: {
                        text: 'Usar esta imagem'
                    },
                    multiple: false
                });

                customUploader.on('select', function () {
                    var attachment = customUploader.state().get('selection').first().toJSON();
                    jQuery('#image_url_imaege_addons_brand_onrill').attr('src', attachment.url);

                    jQuery('#imaege_addons_brand_onrill').val(attachment.id);
                });

                customUploader.open();
            });
        });

    </script>
    <?php


}

// Salva os dados dos novos campos de texto
add_action('woocommerce_update_options_addons_tab', 'save_custom_settings_fields');


function save_custom_settings_fields()
{

    $imaege_addons_brand_onrill = isset ($_POST['imaege_addons_brand_onrill']) ? $_POST['imaege_addons_brand_onrill'] : '';
    update_option('imaege_addons_brand_onrill', $imaege_addons_brand_onrill);
    // Campo 1
    $pack_explorer_already_added = isset ($_POST['pack-explorer_already_added']) ? $_POST['pack-explorer_already_added'] : '';
    update_option('pack-explorer_already_added', $pack_explorer_already_added);

    // Campo 1
    $pack_explorer_already_added = isset ($_POST['pack-explorer_already_added']) ? $_POST['pack-explorer_already_added'] : '';
    update_option('pack-explorer_already_added', $pack_explorer_already_added);

    // Campo 2
    $roof_rack_already_added = isset ($_POST['roof-rack_already_added']) ? $_POST['roof-rack_already_added'] : '';
    update_option('roof-rack_already_added', $roof_rack_already_added);

    // Campo 3
    $locker_already_added = isset ($_POST['locker_already_added']) ? $_POST['locker_already_added'] : '';
    update_option('locker_already_added', $locker_already_added);

    // Campo 3
    $locker_roof_already_added = isset ($_POST['locker_roof_already_added']) ? $_POST['locker_roof_already_added'] : '';
    update_option('locker_roof_already_added', $locker_roof_already_added);


    // Campo 1
    $pack_explorer_already_selected = isset ($_POST['pack-explorer_already_selected']) ? $_POST['pack-explorer_already_selected'] : '';
    update_option('pack-explorer_already_selected', $pack_explorer_already_selected);

    // Campo 2
    $roof_rack_already_selected = isset ($_POST['roof-rack_already_selected']) ? $_POST['roof-rack_already_selected'] : '';
    update_option('roof-rack_already_selected', $roof_rack_already_selected);

    // Campo 3
    $locker_already_selected = isset ($_POST['locker_already_selected']) ? $_POST['locker_already_selected'] : '';
    update_option('locker_already_selected', $locker_already_selected);

    // Campo 3
    $locker_roof_already_selected = isset ($_POST['locker_roof_already_selected']) ? $_POST['locker_roof_already_selected'] : '';
    update_option('locker_roof_already_selected', $locker_roof_already_selected);
}

// Adicione este script ao seu arquivo functions.php ou a um arquivo JavaScript separado, que será enfileirado no frontend ou no backend, dependendo de onde você deseja usar isso.
add_action('admin_enqueue_scripts', 'enqueue_custom_admin_scripts');
function enqueue_custom_admin_scripts()
{
    wp_enqueue_media();
    wp_enqueue_script('custom-admin-script', get_stylesheet_directory_uri() . '/js/custom-admin-script.js', array('jquery'), null, true);
}

//upload svg
function cc_mime_types($mimes)
{
    $mimes['svg'] = 'image/svg+xml';
    return $mimes;
}
add_filter('upload_mimes', 'cc_mime_types');




// Remove os links dos nomes dos produtos no carrinho


/*

add_action('wp_footer', 'trigger_for_ajax_add_to_cart');
function trigger_for_ajax_add_to_cart()
{
    if ((
        isset($_POST['add-to-cart']) && $_POST['add-to-cart'] > 0
        && isset($_POST['quantity']) && $_POST['quantity'] > 0
    ) && (isset($_POST['addons_variation']) || isset($_POST['addons_simple']))) :
    ?>
<script type="text/javascript">
(function($) {

    showAlertPopUp({
        msg: 'If necessary, <a href="<?= wc_get_cart_url() ?>"> click View Cart </a> to change addons quantity.',

    });
})(jQuery);
</script>
<?php
    endif;
}


eliminar variation  with-wetsuit'
add_action('wp_footer', 'aa');

function aa()
{
    global $wpdb;

    // Consulta SQL para obter todos os IDs de produto com a variação especificada
    $variation_ids = $wpdb->get_col("
        SELECT post_id 
        FROM {$wpdb->postmeta} 
        WHERE meta_key = 'attribute_pa_with-wetsuit' 
        AND meta_value = 'with-wetsuit'
    ");

    // Verifica se há variações e inicia o loop
    if ($variation_ids) {
        foreach ($variation_ids as $variation_id) {
            // Exclui a variação
            $wpdb->query("DELETE FROM {$wpdb->posts} WHERE ID = {$variation_id}");
            $wpdb->query("DELETE FROM {$wpdb->postmeta} WHERE post_id = {$variation_id}");
        }
        echo 'Variações eliminadas com sucesso.';
    } else {
        echo 'Nenhuma variação encontrada para excluir.';
    }
}*/